package com.temboo.Library.Amazon.Marketplace.Feeds;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetFeedSubmissionResult

Returns the feed processing report and the Content-MD5 header.
*/
public class GetFeedSubmissionResult extends Choreography {

	/**
	Create a new instance of the GetFeedSubmissionResult Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetFeedSubmissionResult(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Feeds/GetFeedSubmissionResult"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetFeedSubmissionResultInputSet
	*/
	public GetFeedSubmissionResultInputSet newInputSet() {
		return new GetFeedSubmissionResultInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetFeedSubmissionResultResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetFeedSubmissionResultResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetFeedSubmissionResult
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetFeedSubmissionResultInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the FeedSubmissionId input for this Choreo. 

		@param String - (required, string) A FeedSubmmissionId value.
		*/
		public void set_FeedSubmissionId(String value) {
			this.setInput("FeedSubmissionId", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetFeedSubmissionResult Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetFeedSubmissionResultResultSet extends ResultSet {
		public GetFeedSubmissionResultResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ContentMD5Header" output from this Choreo execution

		@return String - (string) The Content MD5 header returned from Amazon. This can used to check against an MD5 hash that you generate before submitting the feed to verify that the feed was submitted correctly.
		*/
		public String get_ContentMD5Header() {
			return this.getResultString("ContentMD5Header");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Stores the response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
