package com.temboo.Library.Amazon.CloudDrive.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadFile

Calls the Amazon Cloud Drive API to upload a file to Amazon Cloud Drive.
*/
public class UploadFile extends Choreography {

	/**
	Create a new instance of the UploadFile Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadFile(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/CloudDrive/Files/UploadFile"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadFileInputSet
	*/
	public UploadFileInputSet newInputSet() {
		return new UploadFileInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadFileResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadFileResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadFile
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadFileInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (required, string) The Content-Type of the file that is being uploaded (e.g., image/jpeg, text/plain, etc.) Defaults to application/octet-stream.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the ContentURL input for this Choreo. 

		@param String - (optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
		*/
		public void set_ContentURL(String value) {
			this.setInput("ContentURL", value);
		}


		/** 
		Set the value of the FileContent input for this Choreo. 

		@param String - (conditional, string) The Base64 encoded contents of the file to upload.
		*/
		public void set_FileContent(String value) {
			this.setInput("FileContent", value);
		}


		/** 
		Set the value of the HandleRequestThrottling input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
		*/
		public void set_HandleRequestThrottling(Boolean value) {
			this.setInput("HandleRequestThrottling", value);
		}

		/** 
		Set the value of the HandleRequestThrottling input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
		*/
		public void set_HandleRequestThrottling(String value) {
			this.setInput("HandleRequestThrottling", value);	
		}
		/** 
		Set the value of the Labels input for this Choreo. 

		@param String - (optional, json) A JSON array containing labels to apply to the file.
		*/
		public void set_Labels(String value) {
			this.setInput("Labels", value);
		}


		/** 
		Set the value of the LocalID input for this Choreo. 

		@param String - (optional, string) A unique ID within the application. Multiple POSTs with the same localId from the same application will result in the same node-id. If not provided the server will generate a node-id.
		*/
		public void set_LocalID(String value) {
			this.setInput("LocalID", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The name of the file being uploaded.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Parents input for this Choreo. 

		@param String - (optional, json) A JSON array containing parent IDs associated with the new folder.
		*/
		public void set_Parents(String value) {
			this.setInput("Parents", value);
		}


		/** 
		Set the value of the Properties input for this Choreo. 

		@param String - (optional, json) A JSON object containing properties to be applied to the file.
		*/
		public void set_Properties(String value) {
			this.setInput("Properties", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the Supress input for this Choreo. 

		@param String - (optional, string) Valid values are: "deduplication" (disables checking for duplicates when uploading) and "process" (disables any processing Amazon may do on the file).
		*/
		public void set_Supress(String value) {
			this.setInput("Supress", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadFile Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadFileResultSet extends ResultSet {
		public UploadFileResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
