package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddBasicListing

Allows you create a basic listing on eBay using scalar inputs rather than an XML request.
*/
public class AddBasicListing extends Choreography {

	/**
	Create a new instance of the AddBasicListing Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddBasicListing(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/AddBasicListing"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddBasicListingInputSet
	*/
	public AddBasicListingInputSet newInputSet() {
		return new AddBasicListingInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddBasicListingResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddBasicListingResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddBasicListing
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddBasicListingInputSet extends InputSet {
		/** 
		Set the value of the BuyItNowPrice input for this Choreo. 

		@param BigDecimal - (optional, decimal) Allows a user to purchase the item at a Buy It Now price and end the auction immediately.
		*/
		public void set_BuyItNowPrice(BigDecimal value) {
			this.setInput("BuyItNowPrice", value);
		}

		/** 
		Set the value of the BuyItNowPrice input for this Choreo as a String. 

		@param String - (optional, decimal) Allows a user to purchase the item at a Buy It Now price and end the auction immediately.
		*/
		public void set_BuyItNowPrice(String value) {
			this.setInput("BuyItNowPrice", value);	
		}
		/** 
		Set the value of the CategoryID input for this Choreo. 

		@param Integer - (conditional, integer) The numeric ID for a category on eBay. Category IDs can be retrieved with the GetCategories Choreo.
		*/
		public void set_CategoryID(Integer value) {
			this.setInput("CategoryID", value);
		}

		/** 
		Set the value of the CategoryID input for this Choreo as a String. 

		@param String - (conditional, integer) The numeric ID for a category on eBay. Category IDs can be retrieved with the GetCategories Choreo.
		*/
		public void set_CategoryID(String value) {
			this.setInput("CategoryID", value);	
		}
		/** 
		Set the value of the ConditionID input for this Choreo. 

		@param Integer - (conditional, integer) The numeric ID (e.g., 1000) for the item condition.
		*/
		public void set_ConditionID(Integer value) {
			this.setInput("ConditionID", value);
		}

		/** 
		Set the value of the ConditionID input for this Choreo as a String. 

		@param String - (conditional, integer) The numeric ID (e.g., 1000) for the item condition.
		*/
		public void set_ConditionID(String value) {
			this.setInput("ConditionID", value);	
		}
		/** 
		Set the value of the Country input for this Choreo. 

		@param String - (conditional, string) The country where the item is located in.
		*/
		public void set_Country(String value) {
			this.setInput("Country", value);
		}


		/** 
		Set the value of the Currency input for this Choreo. 

		@param String - (conditional, string) The currency associated with the item price.
		*/
		public void set_Currency(String value) {
			this.setInput("Currency", value);
		}


		/** 
		Set the value of the DispatchTimeMax input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the maximum number of business days the seller commits to for preparing an item to be shipped after receiving a cleared payment.
		*/
		public void set_DispatchTimeMax(Integer value) {
			this.setInput("DispatchTimeMax", value);
		}

		/** 
		Set the value of the DispatchTimeMax input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the maximum number of business days the seller commits to for preparing an item to be shipped after receiving a cleared payment.
		*/
		public void set_DispatchTimeMax(String value) {
			this.setInput("DispatchTimeMax", value);	
		}
		/** 
		Set the value of the ExpeditedService input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not the seller is offering expedited shipping service options.
		*/
		public void set_ExpeditedService(Boolean value) {
			this.setInput("ExpeditedService", value);
		}

		/** 
		Set the value of the ExpeditedService input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not the seller is offering expedited shipping service options.
		*/
		public void set_ExpeditedService(String value) {
			this.setInput("ExpeditedService", value);	
		}
		/** 
		Set the value of the ItemDescription input for this Choreo. 

		@param String - (conditional, string) The seller's description of the item.
		*/
		public void set_ItemDescription(String value) {
			this.setInput("ItemDescription", value);
		}


		/** 
		Set the value of the ListingDuration input for this Choreo. 

		@param String - (conditional, string) The number of days the seller wants the listing to be active (e.g., Days_7). A complete list of accepted values is returned when calling GetCategoryFeatures with DetailLevel set to ReturnAll.
		*/
		public void set_ListingDuration(String value) {
			this.setInput("ListingDuration", value);
		}


		/** 
		Set the value of the ListingType input for this Choreo. 

		@param String - (optional, string) The format of the listing the seller wants to use. Valid values are: AdType, Chinese, FixedPriceItem, Half, LeadGeneration.
		*/
		public void set_ListingType(String value) {
			this.setInput("ListingType", value);
		}


		/** 
		Set the value of the PayPalEmailAddress input for this Choreo. 

		@param String - (conditional, string) The seller's PayPal email address. Required when a PaymentMethod is PayPal.
		*/
		public void set_PayPalEmailAddress(String value) {
			this.setInput("PayPalEmailAddress", value);
		}


		/** 
		Set the value of the PaymentMethods input for this Choreo. 

		@param String - (conditional, string) Identifies the payment method (such as PayPal) that the seller will accept when the buyer pays for the item. This can be a comma-separated list (e.g., VisaMC,PayPal).
		*/
		public void set_PaymentMethods(String value) {
			this.setInput("PaymentMethods", value);
		}


		/** 
		Set the value of the PictureURL input for this Choreo. 

		@param String - (conditional, string) The URL for a picture associated with an item. Multiple URLs can be specified as a comma-separated list.
		*/
		public void set_PictureURL(String value) {
			this.setInput("PictureURL", value);
		}


		/** 
		Set the value of the PostalCode input for this Choreo. 

		@param String - (conditional, string) The Postal code of the place where the item is located.
		*/
		public void set_PostalCode(String value) {
			this.setInput("PostalCode", value);
		}


		/** 
		Set the value of the Quantity input for this Choreo. 

		@param Integer - (conditional, integer) Indicates the quantity of items available for purchase in the listing. Required for all auction listings and for non-variation, fixed-price listings. For auction listings, this value is always '1'.
		*/
		public void set_Quantity(Integer value) {
			this.setInput("Quantity", value);
		}

		/** 
		Set the value of the Quantity input for this Choreo as a String. 

		@param String - (conditional, integer) Indicates the quantity of items available for purchase in the listing. Required for all auction listings and for non-variation, fixed-price listings. For auction listings, this value is always '1'.
		*/
		public void set_Quantity(String value) {
			this.setInput("Quantity", value);	
		}
		/** 
		Set the value of the RefundOption input for this Choreo. 

		@param String - (optional, string) Indicates how the seller will compensate the buyer for a returned item (e.g. MoneyBack).
		*/
		public void set_RefundOption(String value) {
			this.setInput("RefundOption", value);
		}


		/** 
		Set the value of the ReservePrice input for this Choreo. 

		@param BigDecimal - (optional, decimal) The lowest price at which the seller is willing to sell the item.
		*/
		public void set_ReservePrice(BigDecimal value) {
			this.setInput("ReservePrice", value);
		}

		/** 
		Set the value of the ReservePrice input for this Choreo as a String. 

		@param String - (optional, decimal) The lowest price at which the seller is willing to sell the item.
		*/
		public void set_ReservePrice(String value) {
			this.setInput("ReservePrice", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ReturnPolicyDescription input for this Choreo. 

		@param String - (optional, string) The text description of return policy details.
		*/
		public void set_ReturnPolicyDescription(String value) {
			this.setInput("ReturnPolicyDescription", value);
		}


		/** 
		Set the value of the ReturnsAcceptedOption input for this Choreo. 

		@param String - (conditional, string) Indicates whether the seller allows the buyer to return the item (e.g., ReturnsAccepted).
		*/
		public void set_ReturnsAcceptedOption(String value) {
			this.setInput("ReturnsAcceptedOption", value);
		}


		/** 
		Set the value of the ReturnsWithinOption input for this Choreo. 

		@param String - (optional, string) The period of time the buyer has to return the item (e.g., Days_14). To accepted values for this field, call GeteBayDetails with DetailName set to ReturnPolicyDetails.
		*/
		public void set_ReturnsWithinOption(String value) {
			this.setInput("ReturnsWithinOption", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the ShippingService input for this Choreo. 

		@param String - (conditional, string) The name of the shipping service offered (e.g. UPSGround, USPSMedia).
		*/
		public void set_ShippingService(String value) {
			this.setInput("ShippingService", value);
		}


		/** 
		Set the value of the ShippingServiceAdditionalCost input for this Choreo. 

		@param BigDecimal - (optional, decimal) Shipping costs in addition to the value specified for the ShippingServiceCost parameter.
		*/
		public void set_ShippingServiceAdditionalCost(BigDecimal value) {
			this.setInput("ShippingServiceAdditionalCost", value);
		}

		/** 
		Set the value of the ShippingServiceAdditionalCost input for this Choreo as a String. 

		@param String - (optional, decimal) Shipping costs in addition to the value specified for the ShippingServiceCost parameter.
		*/
		public void set_ShippingServiceAdditionalCost(String value) {
			this.setInput("ShippingServiceAdditionalCost", value);	
		}
		/** 
		Set the value of the ShippingServiceCost input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The cost for shipping the item.
		*/
		public void set_ShippingServiceCost(BigDecimal value) {
			this.setInput("ShippingServiceCost", value);
		}

		/** 
		Set the value of the ShippingServiceCost input for this Choreo as a String. 

		@param String - (conditional, decimal) The cost for shipping the item.
		*/
		public void set_ShippingServiceCost(String value) {
			this.setInput("ShippingServiceCost", value);	
		}
		/** 
		Set the value of the ShippingType input for this Choreo. 

		@param String - (conditional, string) The shipping cost model offered by the seller. Valid values are: Calculated, CalculatedDomesticFlatInternational, Flat, FlatDomesticCalculatedInternational, FreightFlat, NotSpecified.
		*/
		public void set_ShippingType(String value) {
			this.setInput("ShippingType", value);
		}


		/** 
		Set the value of the Site input for this Choreo. 

		@param String - (optional, string) The name of the site on which the item is listed. This should corresponse to the SiteID. Default value is "US".
		*/
		public void set_Site(String value) {
			this.setInput("Site", value);
		}


		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the StartPrice input for this Choreo. 

		@param BigDecimal - (conditional, decimal) This value indicates the starting price of the item when it is listed for the first time.
		*/
		public void set_StartPrice(BigDecimal value) {
			this.setInput("StartPrice", value);
		}

		/** 
		Set the value of the StartPrice input for this Choreo as a String. 

		@param String - (conditional, decimal) This value indicates the starting price of the item when it is listed for the first time.
		*/
		public void set_StartPrice(String value) {
			this.setInput("StartPrice", value);	
		}
		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (conditional, string) The title of the item as it appears in the listing or search results.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddBasicListing Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddBasicListingResultSet extends ResultSet {
		public AddBasicListingResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
