package com.temboo.Library.eBay.Finding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FindCompletedItems

Retrieves items whose listings are completed and are no longer available for sale on eBay.
*/
public class FindCompletedItems extends Choreography {

	/**
	Create a new instance of the FindCompletedItems Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FindCompletedItems(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Finding/FindCompletedItems"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FindCompletedItemsInputSet
	*/
	public FindCompletedItemsInputSet newInputSet() {
		return new FindCompletedItemsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FindCompletedItemsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FindCompletedItemsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FindCompletedItems
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FindCompletedItemsInputSet extends InputSet {
		/** 
		Set the value of the FindCompletedItemsRequest input for this Choreo. 

		@param String - (optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
		*/
		public void set_FindCompletedItemsRequest(String value) {
			this.setInput("FindCompletedItemsRequest", value);
		}


		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The unique identifier for the application.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AspectFilters input for this Choreo. 

		@param String - (optional, json) A dictionary of key/value pairs to use as aspect filters for the request.
		*/
		public void set_AspectFilters(String value) {
			this.setInput("AspectFilters", value);
		}


		/** 
		Set the value of the CategoryID input for this Choreo. 

		@param String - (optional, string) Filters the results by category ID.
		*/
		public void set_CategoryID(String value) {
			this.setInput("CategoryID", value);
		}


		/** 
		Set the value of the EntriesPerPage input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of records to return in the result.
		*/
		public void set_EntriesPerPage(Integer value) {
			this.setInput("EntriesPerPage", value);
		}

		/** 
		Set the value of the EntriesPerPage input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of records to return in the result.
		*/
		public void set_EntriesPerPage(String value) {
			this.setInput("EntriesPerPage", value);	
		}
		/** 
		Set the value of the GlobalID input for this Choreo. 

		@param Integer - (optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
		*/
		public void set_GlobalID(Integer value) {
			this.setInput("GlobalID", value);
		}

		/** 
		Set the value of the GlobalID input for this Choreo as a String. 

		@param String - (optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
		*/
		public void set_GlobalID(String value) {
			this.setInput("GlobalID", value);	
		}
		/** 
		Set the value of the ItemFilters input for this Choreo. 

		@param String - (optional, json) A dictionary of key/value pairs to use as item filters for the request.
		*/
		public void set_ItemFilters(String value) {
			this.setInput("ItemFilters", value);
		}


		/** 
		Set the value of the Keywords input for this Choreo. 

		@param String - (conditional, string) Filters the results by one or more keywords.
		*/
		public void set_Keywords(String value) {
			this.setInput("Keywords", value);
		}


		/** 
		Set the value of the OutputSelector input for this Choreo. 

		@param String - (optional, string) Controls the fields that are returned in the response (e.g., GalleryInfo).
		*/
		public void set_OutputSelector(String value) {
			this.setInput("OutputSelector", value);
		}


		/** 
		Set the value of the PageNumber input for this Choreo. 

		@param Integer - (optional, integer) Specifies the page number of the results to return.
		*/
		public void set_PageNumber(Integer value) {
			this.setInput("PageNumber", value);
		}

		/** 
		Set the value of the PageNumber input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the page number of the results to return.
		*/
		public void set_PageNumber(String value) {
			this.setInput("PageNumber", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Valid values: BestMatch, BidCountMost, CountryAscending, CountryDescending, DistanceNearest, CurrentPriceHighest, EndTimeSoonest, PricePlusShippingHighest, PricePlusShippingLowest, StartTimeNewest.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FindCompletedItems Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FindCompletedItemsResultSet extends ResultSet {
		public FindCompletedItemsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
