package com.temboo.Library.Zoho.CRM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
InsertRecords

Inserts records into your Zoho CRM account.
*/
public class InsertRecords extends Choreography {

	/**
	Create a new instance of the InsertRecords Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public InsertRecords(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zoho/CRM/InsertRecords"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return InsertRecordsInputSet
	*/
	public InsertRecordsInputSet newInputSet() {
		return new InsertRecordsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public InsertRecordsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new InsertRecordsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the InsertRecords
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class InsertRecordsInputSet extends InputSet {
		/** 
		Set the value of the AnnualRevenue input for this Choreo. 

		@param String - (optional, string) Corresponds to the Annual Revenue field in Zoho
		*/
		public void set_AnnualRevenue(String value) {
			this.setInput("AnnualRevenue", value);
		}


		/** 
		Set the value of the AuthenticationToken input for this Choreo. 

		@param String - (required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.
		*/
		public void set_AuthenticationToken(String value) {
			this.setInput("AuthenticationToken", value);
		}


		/** 
		Set the value of the CampaignSource input for this Choreo. 

		@param String - (optional, string) Corresponds to the Campaign Source field in Zoho
		*/
		public void set_CampaignSource(String value) {
			this.setInput("CampaignSource", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) Corresponds to the City field in Zoho
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the Company input for this Choreo. 

		@param String - (optional, string) Corresponds to the Company field in Zoho
		*/
		public void set_Company(String value) {
			this.setInput("Company", value);
		}


		/** 
		Set the value of the Country input for this Choreo. 

		@param String - (optional, string) Corresponds to the Country field in Zoho
		*/
		public void set_Country(String value) {
			this.setInput("Country", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) Corresponds to the Description field in Zoho
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) Corresponds to the Email field in Zoho
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the EmailOptOut input for this Choreo. 

		@param Boolean - (optional, boolean) Corresponds to the Email Opt Out field in Zoho. Defaults to 0 for false.
		*/
		public void set_EmailOptOut(Boolean value) {
			this.setInput("EmailOptOut", value);
		}

		/** 
		Set the value of the EmailOptOut input for this Choreo as a String. 

		@param String - (optional, boolean) Corresponds to the Email Opt Out field in Zoho. Defaults to 0 for false.
		*/
		public void set_EmailOptOut(String value) {
			this.setInput("EmailOptOut", value);	
		}
		/** 
		Set the value of the Fax input for this Choreo. 

		@param String - (optional, string) Corresponds to the Fax field in Zoho
		*/
		public void set_Fax(String value) {
			this.setInput("Fax", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (optional, string) Corresponds to the First Name field in Zoho
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the Industry input for this Choreo. 

		@param String - (optional, string) Corresponds to the Industry field in Zoho
		*/
		public void set_Industry(String value) {
			this.setInput("Industry", value);
		}


		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (required, string) Corresponds to the Last Name field in Zoho
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the LeadOwner input for this Choreo. 

		@param String - (optional, string) Corresponds to the Lead Owner field in Zoho
		*/
		public void set_LeadOwner(String value) {
			this.setInput("LeadOwner", value);
		}


		/** 
		Set the value of the LeadSource input for this Choreo. 

		@param String - (optional, string) Corresponds to the Lead Source field in Zoho
		*/
		public void set_LeadSource(String value) {
			this.setInput("LeadSource", value);
		}


		/** 
		Set the value of the LeadStatus input for this Choreo. 

		@param String - (optional, string) Corresponds to the Lead Status field in Zoho
		*/
		public void set_LeadStatus(String value) {
			this.setInput("LeadStatus", value);
		}


		/** 
		Set the value of the Mobile input for this Choreo. 

		@param String - (optional, string) Corresponds to the Mobile field in Zoho
		*/
		public void set_Mobile(String value) {
			this.setInput("Mobile", value);
		}


		/** 
		Set the value of the Module input for this Choreo. 

		@param String - (optional, string) The Zoho module you want to access. Defaults to 'Leads'.
		*/
		public void set_Module(String value) {
			this.setInput("Module", value);
		}


		/** 
		Set the value of the NumOfEmployees input for this Choreo. 

		@param String - (optional, string) Corresponds to the Num Of Employees field in Zoho
		*/
		public void set_NumOfEmployees(String value) {
			this.setInput("NumOfEmployees", value);
		}


		/** 
		Set the value of the Phone input for this Choreo. 

		@param String - (optional, string) Corresponds to the Phone field in Zoho
		*/
		public void set_Phone(String value) {
			this.setInput("Phone", value);
		}


		/** 
		Set the value of the Rating input for this Choreo. 

		@param String - (optional, string) Corresponds to the Rating field in Zoho
		*/
		public void set_Rating(String value) {
			this.setInput("Rating", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid formats are: json and xml (the default).
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Salutation input for this Choreo. 

		@param String - (optional, string) Corresponds to the Salutation field in Zoho
		*/
		public void set_Salutation(String value) {
			this.setInput("Salutation", value);
		}


		/** 
		Set the value of the SkypeID input for this Choreo. 

		@param String - (optional, string) Corresponds to the Skype ID field in Zoho
		*/
		public void set_SkypeID(String value) {
			this.setInput("SkypeID", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Corresponds to the State field in Zoho
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Street input for this Choreo. 

		@param String - (optional, string) Corresponds to the Street field in Zoho
		*/
		public void set_Street(String value) {
			this.setInput("Street", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) Corresponds to the Title field in Zoho
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the Website input for this Choreo. 

		@param String - (optional, string) Corresponds to the Website field in Zoho
		*/
		public void set_Website(String value) {
			this.setInput("Website", value);
		}


		/** 
		Set the value of the ZipCode input for this Choreo. 

		@param Integer - (optional, integer) Corresponds to the Zip Code field in Zoho
		*/
		public void set_ZipCode(Integer value) {
			this.setInput("ZipCode", value);
		}

		/** 
		Set the value of the ZipCode input for this Choreo as a String. 

		@param String - (optional, integer) Corresponds to the Zip Code field in Zoho
		*/
		public void set_ZipCode(String value) {
			this.setInput("ZipCode", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the InsertRecords Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class InsertRecordsResultSet extends ResultSet {
		public InsertRecordsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
