package com.temboo.Library.Zendesk.Tickets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateTicket

Creates a new ticket.
*/
public class CreateTicket extends Choreography {

	/**
	Create a new instance of the CreateTicket Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateTicket(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Tickets/CreateTicket"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateTicketInputSet
	*/
	public CreateTicketInputSet newInputSet() {
		return new CreateTicketInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateTicketResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateTicketResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateTicket
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateTicketInputSet extends InputSet {
		/** 
		Set the value of the Comment input for this Choreo. 

		@param String - (conditional, string) The comment for the ticket that is being created.
		*/
		public void set_Comment(String value) {
			this.setInput("Comment", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (i.e. temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Subject input for this Choreo. 

		@param String - (conditional, string) The subject for the ticket that is being created.
		*/
		public void set_Subject(String value) {
			this.setInput("Subject", value);
		}


		/** 
		Set the value of the TicketData input for this Choreo. 

		@param String - (optional, json) A JSON-formatted string containing the ticket properties you wish to set. This can be used as an alternative to setting individual inputs representing ticket properties.
		*/
		public void set_TicketData(String value) {
			this.setInput("TicketData", value);
		}


		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (optional, string) The token associated with an upload to attach to this ticket. Note that tokens can be retrieved by running the UploadFile Choreo.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateTicket Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateTicketResultSet extends ResultSet {
		public CreateTicketResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
