package com.temboo.Library.YouTube.Playlists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdatePlaylist

Updates a playlist.
*/
public class UpdatePlaylist extends Choreography {

	/**
	Create a new instance of the UpdatePlaylist Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdatePlaylist(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/YouTube/Playlists/UpdatePlaylist"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdatePlaylistInputSet
	*/
	public UpdatePlaylistInputSet newInputSet() {
		return new UpdatePlaylistInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdatePlaylistResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdatePlaylistResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdatePlaylist
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdatePlaylistInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) The playlist's description.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the Part input for this Choreo. 

		@param String - (optional, string) A comma-separated list of fields that are being set and that will be returned in the response (i.e. snippet,status).
		*/
		public void set_Part(String value) {
			this.setInput("Part", value);
		}


		/** 
		Set the value of the PlaylistID input for this Choreo. 

		@param String - (required, string) The id of the playlist to update.
		*/
		public void set_PlaylistID(String value) {
			this.setInput("PlaylistID", value);
		}


		/** 
		Set the value of the PrivacyStatus input for this Choreo. 

		@param String - (optional, string) The playlist's privacy status. Valid values are: private or public.
		*/
		public void set_PrivacyStatus(String value) {
			this.setInput("PrivacyStatus", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (required, string) The title of the playlist.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdatePlaylist Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdatePlaylistResultSet extends ResultSet {
		public UpdatePlaylistResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
