package com.temboo.Library.Wordnik.Words;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ReverseDictionary

Retrieves a reverse dictionary search for a given word.
*/
public class ReverseDictionary extends Choreography {

	/**
	Create a new instance of the ReverseDictionary Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ReverseDictionary(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wordnik/Words/ReverseDictionary"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ReverseDictionaryInputSet
	*/
	public ReverseDictionaryInputSet newInputSet() {
		return new ReverseDictionaryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ReverseDictionaryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ReverseDictionaryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ReverseDictionary
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ReverseDictionaryInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key from Wordnik.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ExcludePartOfSpeech input for this Choreo. 

		@param String - (optional, string) Excludes the specified comma-delimited parts of speech from the results returned. Acceptable values include: adjective, noun, etc. See docs for full list.
		*/
		public void set_ExcludePartOfSpeech(String value) {
			this.setInput("ExcludePartOfSpeech", value);
		}


		/** 
		Set the value of the ExcludeSource input for this Choreo. 

		@param String - (optional, string) Exclude these comma-delimited source dictionaries: ahd, century, wiktionary,webster, wordnet.
		*/
		public void set_ExcludeSource(String value) {
			this.setInput("ExcludeSource", value);
		}


		/** 
		Set the value of the ExpandTerms input for this Choreo. 

		@param String - (optional, any) Expand terms by either: synonym or hypernym.
		*/
		public void set_ExpandTerms(String value) {
			this.setInput("ExpandTerms", value);
		}


		/** 
		Set the value of the IncludePartOfSpeech input for this Choreo. 

		@param String - (optional, string) Only includes the specified comma-delimited parts of speech. Acceptable values include: adjective, noun, etc. See docs for full list.
		*/
		public void set_IncludePartOfSpeech(String value) {
			this.setInput("IncludePartOfSpeech", value);
		}


		/** 
		Set the value of the IncludeSource input for this Choreo. 

		@param String - (optional, string) Only include these comma-delimited source dictionaries: ahd, century, wiktionary,webster, wordnet.
		*/
		public void set_IncludeSource(String value) {
			this.setInput("IncludeSource", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Maximum number of results to return. Defaults to 10.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Maximum number of results to return. Defaults to 10.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the MaxCorpus input for this Choreo. 

		@param Integer - (optional, integer) Results include a corpus frequency count for each word returned. When this input is specified, results are limited to words with a corpus frequency count below the given number.
		*/
		public void set_MaxCorpus(Integer value) {
			this.setInput("MaxCorpus", value);
		}

		/** 
		Set the value of the MaxCorpus input for this Choreo as a String. 

		@param String - (optional, integer) Results include a corpus frequency count for each word returned. When this input is specified, results are limited to words with a corpus frequency count below the given number.
		*/
		public void set_MaxCorpus(String value) {
			this.setInput("MaxCorpus", value);	
		}
		/** 
		Set the value of the MaxLength input for this Choreo. 

		@param Integer - (optional, integer) Maximum word length.
		*/
		public void set_MaxLength(Integer value) {
			this.setInput("MaxLength", value);
		}

		/** 
		Set the value of the MaxLength input for this Choreo as a String. 

		@param String - (optional, integer) Maximum word length.
		*/
		public void set_MaxLength(String value) {
			this.setInput("MaxLength", value);	
		}
		/** 
		Set the value of the MinCorpus input for this Choreo. 

		@param Integer - (optional, integer) Results include a corpus frequency count for each word returned. When this input is specified, results are limited to words with a corpus frequency count above the given number.
		*/
		public void set_MinCorpus(Integer value) {
			this.setInput("MinCorpus", value);
		}

		/** 
		Set the value of the MinCorpus input for this Choreo as a String. 

		@param String - (optional, integer) Results include a corpus frequency count for each word returned. When this input is specified, results are limited to words with a corpus frequency count above the given number.
		*/
		public void set_MinCorpus(String value) {
			this.setInput("MinCorpus", value);	
		}
		/** 
		Set the value of the MinLength input for this Choreo. 

		@param Integer - (optional, integer) ?Minimum word length.
		*/
		public void set_MinLength(Integer value) {
			this.setInput("MinLength", value);
		}

		/** 
		Set the value of the MinLength input for this Choreo as a String. 

		@param String - (optional, integer) ?Minimum word length.
		*/
		public void set_MinLength(String value) {
			this.setInput("MinLength", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (required, string) Word or fragment to query for in Wordnik.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Response can be either JSON or XML. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Skip input for this Choreo. 

		@param Integer - (optional, integer) Number of results to skip.
		*/
		public void set_Skip(Integer value) {
			this.setInput("Skip", value);
		}

		/** 
		Set the value of the Skip input for this Choreo as a String. 

		@param String - (optional, integer) Number of results to skip.
		*/
		public void set_Skip(String value) {
			this.setInput("Skip", value);	
		}
		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) Results can be sorted by: alpha, count, or length.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Indicate the order to sort, either asc (ascending) or desc (descending).
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the WordSense input for this Choreo. 

		@param String - (optional, string) Restricts words and finds the closest sense to the one indicated.
		*/
		public void set_WordSense(String value) {
			this.setInput("WordSense", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ReverseDictionary Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ReverseDictionaryResultSet extends ResultSet {
		public ReverseDictionaryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wordnik.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
