package com.temboo.Library.Wordnik.WordList;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetWordsInWordList

Retrievs the words in a word list.
*/
public class GetWordsInWordList extends Choreography {

	/**
	Create a new instance of the GetWordsInWordList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetWordsInWordList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wordnik/WordList/GetWordsInWordList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetWordsInWordListInputSet
	*/
	public GetWordsInWordListInputSet newInputSet() {
		return new GetWordsInWordListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetWordsInWordListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetWordsInWordListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetWordsInWordList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetWordsInWordListInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from Wordnik.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Limits teh number of results returned. Defaults to 100.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Limits teh number of results returned. Defaults to 100.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) The Password of the Wordnik user account.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Response can be either JSON or XML. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Skip input for this Choreo. 

		@param Integer - (optional, integer) Number of results to skip. Defaults to 0.
		*/
		public void set_Skip(Integer value) {
			this.setInput("Skip", value);
		}

		/** 
		Set the value of the Skip input for this Choreo as a String. 

		@param String - (optional, integer) Number of results to skip. Defaults to 0.
		*/
		public void set_Skip(String value) {
			this.setInput("Skip", value);	
		}
		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) Sorts the results by either alpha (alphabetically) or createDate (the date created). Defaults to createDate.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) The direction to sort results by either asc (ascending) or desc (descending). Defaults to desc.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The Username of the Wordnik user.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WordList input for this Choreo. 

		@param String - (required, string) The perma-link for the Word List to retrieve.
		*/
		public void set_WordList(String value) {
			this.setInput("WordList", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetWordsInWordList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetWordsInWordListResultSet extends ResultSet {
		public GetWordsInWordListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wordnik.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
