package com.temboo.Library.Withings.Notification;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetSubscription

Allows your application to check whether the notification service was previously subscribed on a specific user and to retrieve the subscription expiration date.
*/
public class GetSubscription extends Choreography {

	/**
	Create a new instance of the GetSubscription Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetSubscription(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Withings/Notification/GetSubscription"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetSubscriptionInputSet
	*/
	public GetSubscriptionInputSet newInputSet() {
		return new GetSubscriptionInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetSubscriptionResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetSubscriptionResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetSubscription
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetSubscriptionInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the CallbackURL input for this Choreo. 

		@param String - (required, string) The URL used when subscribing to the notification service.
		*/
		public void set_CallbackURL(String value) {
			this.setInput("CallbackURL", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Withings.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Withings.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (required, string) The ID of the user to verify a subscription for.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetSubscription Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetSubscriptionResultSet extends ResultSet {
		public GetSubscriptionResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Withings.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
