package com.temboo.Library.Utilities.Text;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Split

Splits a string into sub-strings delimited by the specified delmiter pattern.
*/
public class Split extends Choreography {

	/**
	Create a new instance of the Split Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Split(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Text/Split"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SplitInputSet
	*/
	public SplitInputSet newInputSet() {
		return new SplitInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SplitResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SplitResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Split
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SplitInputSet extends InputSet {
		/** 
		Set the value of the Delimiter input for this Choreo. 

		@param String - (required, string) The delimiter to search for when splitting the string into sub-strings. See Choreo notes for restrictions with delimiters.
		*/
		public void set_Delimiter(String value) {
			this.setInput("Delimiter", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, multiline) The text that should be split into sub-strings.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Split Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SplitResultSet extends ResultSet {
		public SplitResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) Contains the sub-strings formatted as a JSON array.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
