package com.temboo.Library.Utilities.DataConversions;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CSVToXLS

Converts a CSV formatted file to Base64 encoded Excel data.
*/
public class CSVToXLS extends Choreography {

	/**
	Create a new instance of the CSVToXLS Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CSVToXLS(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/DataConversions/CSVToXLS"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CSVToXLSInputSet
	*/
	public CSVToXLSInputSet newInputSet() {
		return new CSVToXLSInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CSVToXLSResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CSVToXLSResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CSVToXLS
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CSVToXLSInputSet extends InputSet {
		/** 
		Set the value of the CSV input for this Choreo. 

		@param String - (conditional, multiline) The CSV data you want to convert to XLS format. Required unless using the VaultFile input alias (an advanced option used when running Choreos in the Temboo Designer).
		*/
		public void set_CSV(String value) {
			this.setInput("CSV", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - (optional, vault file) A path to a CSV file you've stored in the Vault. This can be used as an alternative to the CSVFile input variable.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CSVToXLS Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CSVToXLSResultSet extends ResultSet {
		public CSVToXLSResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "XLS" output from this Choreo execution

		@return String - (string) The Base64 encoded Excel data.
		*/
		public String get_XLS() {
			return this.getResultString("XLS");
		}
	}
	
}
