package com.temboo.Library.Uber.Estimates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetPriceEstimates

Returns an estimated price range for each product offered at a given location.
*/
public class GetPriceEstimates extends Choreography {

	/**
	Create a new instance of the GetPriceEstimates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetPriceEstimates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Uber/Estimates/GetPriceEstimates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetPriceEstimatesInputSet
	*/
	public GetPriceEstimatesInputSet newInputSet() {
		return new GetPriceEstimatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetPriceEstimatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetPriceEstimatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetPriceEstimates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetPriceEstimatesInputSet extends InputSet {
		/** 
		Set the value of the EndLatitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude coordinate for the destination e.g., 40.650729.
		*/
		public void set_EndLatitude(BigDecimal value) {
			this.setInput("EndLatitude", value);
		}

		/** 
		Set the value of the EndLatitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude coordinate for the destination e.g., 40.650729.
		*/
		public void set_EndLatitude(String value) {
			this.setInput("EndLatitude", value);	
		}
		/** 
		Set the value of the EndLongitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate for the destination e.g., -74.009536.
		*/
		public void set_EndLongitude(BigDecimal value) {
			this.setInput("EndLongitude", value);
		}

		/** 
		Set the value of the EndLongitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate for the destination e.g., -74.009536.
		*/
		public void set_EndLongitude(String value) {
			this.setInput("EndLongitude", value);	
		}
		/** 
		Set the value of the ServerToken input for this Choreo. 

		@param String - (required, string) The Sever Token provided by Uber.
		*/
		public void set_ServerToken(String value) {
			this.setInput("ServerToken", value);
		}


		/** 
		Set the value of the StartLatitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude coordinate for the starting location e.g., 40.71863.
		*/
		public void set_StartLatitude(BigDecimal value) {
			this.setInput("StartLatitude", value);
		}

		/** 
		Set the value of the StartLatitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude coordinate for the starting location e.g., 40.71863.
		*/
		public void set_StartLatitude(String value) {
			this.setInput("StartLatitude", value);	
		}
		/** 
		Set the value of the StartLongitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate for the starting location e.g., -74.005584.
		*/
		public void set_StartLongitude(BigDecimal value) {
			this.setInput("StartLongitude", value);
		}

		/** 
		Set the value of the StartLongitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate for the starting location e.g., -74.005584.
		*/
		public void set_StartLongitude(String value) {
			this.setInput("StartLongitude", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetPriceEstimates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetPriceEstimatesResultSet extends ResultSet {
		public GetPriceEstimatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Uber.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
