package com.temboo.Library.Twitter.Trends;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Place

Retrieves the top 10 trending topics for a specific WOEID.
*/
public class Place extends Choreography {

	/**
	Create a new instance of the Place Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Place(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/Trends/Place"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PlaceInputSet
	*/
	public PlaceInputSet newInputSet() {
		return new PlaceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PlaceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PlaceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Place
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PlaceInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Exclude input for this Choreo. 

		@param Boolean - (optional, boolean) If set to "hashtags", all hashtags from the trends list will be removed.
		*/
		public void set_Exclude(Boolean value) {
			this.setInput("Exclude", value);
		}

		/** 
		Set the value of the Exclude input for this Choreo as a String. 

		@param String - (optional, boolean) If set to "hashtags", all hashtags from the trends list will be removed.
		*/
		public void set_Exclude(String value) {
			this.setInput("Exclude", value);	
		}
		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (required, string) The (WOEID) Yahoo! Where On Earth ID of the location to return trending information for. Global information is available by setting this parameter to 1.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Place Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PlaceResultSet extends ResultSet {
		public PlaceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
