package com.temboo.Library.Twitter.FriendsAndFollowers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateFriendship

Allows you to follow another Twitter user by specifying a Twitter user id or screen name.
*/
public class CreateFriendship extends Choreography {

	/**
	Create a new instance of the CreateFriendship Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateFriendship(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/FriendsAndFollowers/CreateFriendship"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateFriendshipInputSet
	*/
	public CreateFriendshipInputSet newInputSet() {
		return new CreateFriendshipInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateFriendshipResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateFriendshipResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateFriendship
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateFriendshipInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Follow input for this Choreo. 

		@param Boolean - (optional, boolean) A boolean flag that enables notifications for the target user when set to true.
		*/
		public void set_Follow(Boolean value) {
			this.setInput("Follow", value);
		}

		/** 
		Set the value of the Follow input for this Choreo as a String. 

		@param String - (optional, boolean) A boolean flag that enables notifications for the target user when set to true.
		*/
		public void set_Follow(String value) {
			this.setInput("Follow", value);	
		}
		/** 
		Set the value of the ScreenName input for this Choreo. 

		@param String - (conditional, string) The screen name for the friend you want to create a friendship with. Required if UserId isn't specified.
		*/
		public void set_ScreenName(String value) {
			this.setInput("ScreenName", value);
		}


		/** 
		Set the value of the UserId input for this Choreo. 

		@param String - (conditional, string) The user id for the friend you want to create a friendship with. Required if ScreenName isn't specified.
		*/
		public void set_UserId(String value) {
			this.setInput("UserId", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateFriendship Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateFriendshipResultSet extends ResultSet {
		public CreateFriendshipResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
