package com.temboo.Library.Twitter.DirectMessages;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLatestDirectMessage

Retrieves the latest direct message sent to the authenticating user.
*/
public class GetLatestDirectMessage extends Choreography {

	/**
	Create a new instance of the GetLatestDirectMessage Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLatestDirectMessage(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/DirectMessages/GetLatestDirectMessage"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLatestDirectMessageInputSet
	*/
	public GetLatestDirectMessageInputSet newInputSet() {
		return new GetLatestDirectMessageInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLatestDirectMessageResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLatestDirectMessageResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLatestDirectMessage
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLatestDirectMessageInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the IncludeEntities input for this Choreo. 

		@param Boolean - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(Boolean value) {
			this.setInput("IncludeEntities", value);
		}

		/** 
		Set the value of the IncludeEntities input for this Choreo as a String. 

		@param String - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(String value) {
			this.setInput("IncludeEntities", value);	
		}
		/** 
		Set the value of the MaxID input for this Choreo. 

		@param String - (optional, string) Returns results with an ID less than (older than) or equal to the specified ID.
		*/
		public void set_MaxID(String value) {
			this.setInput("MaxID", value);
		}


		/** 
		Set the value of the SinceID input for this Choreo. 

		@param String - (optional, string) Returns results with an ID greater than (more recent than) the specified ID.
		*/
		public void set_SinceID(String value) {
			this.setInput("SinceID", value);
		}


		/** 
		Set the value of the SkipStatus input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, statuses will not be included in the returned user objects.
		*/
		public void set_SkipStatus(Boolean value) {
			this.setInput("SkipStatus", value);
		}

		/** 
		Set the value of the SkipStatus input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, statuses will not be included in the returned user objects.
		*/
		public void set_SkipStatus(String value) {
			this.setInput("SkipStatus", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLatestDirectMessage Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLatestDirectMessageResultSet extends ResultSet {
		public GetLatestDirectMessageResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ID" output from this Choreo execution

		@return String - (string) The message ID.
		*/
		public String get_ID() {
			return this.getResultString("ID");
		}
		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The rate limit ceiling for this particular request.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "RecipientScreenName" output from this Choreo execution

		@return String - (string) The recipient's screen name.
		*/
		public String get_RecipientScreenName() {
			return this.getResultString("RecipientScreenName");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The number of requests left for the 15 minute window.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Reset" output from this Choreo execution

		@return String - (date) The remaining window before the rate limit resets in UTC epoch seconds.
		*/
		public String get_Reset() {
			return this.getResultString("Reset");
		}
		/** 
		Retrieve the value for the "SenderScreenName" output from this Choreo execution

		@return String - (string) The sender's screen name.
		*/
		public String get_SenderScreenName() {
			return this.getResultString("SenderScreenName");
		}
		/** 
		Retrieve the value for the "Text" output from this Choreo execution

		@return String - (string) The message text.
		*/
		public String get_Text() {
			return this.getResultString("Text");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
