package com.temboo.Library.Twilio.SMSMessages;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SendSMS

Sends an SMS to a specified phone number using the Twilio API.
*/
public class SendSMS extends Choreography {

	/**
	Create a new instance of the SendSMS Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SendSMS(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/SMSMessages/SendSMS"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SendSMSInputSet
	*/
	public SendSMSInputSet newInputSet() {
		return new SendSMSInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SendSMSResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SendSMSResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SendSMS
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SendSMSInputSet extends InputSet {
		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the Body input for this Choreo. 

		@param String - (conditional, string) The text of the message.
		*/
		public void set_Body(String value) {
			this.setInput("Body", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (required, string) The purchased Twilio phone number, Twilio Sandbox number, or short code enabled for the type of message you wish to send (SMS or MMS). Format with a '+' and country code e.g., +16175551212.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the MediaURL input for this Choreo. 

		@param String - (optional, string) One or more URLs for media you wish to send with the message. Supported formats include: png, gif, and jpeg. Multiple URLs (up-to 10) should be separated by commas.
		*/
		public void set_MediaURL(String value) {
			this.setInput("MediaURL", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SubAccountSID input for this Choreo. 

		@param String - (optional, string) The SID of the subaccount to send the message from. If not specified, the main AccountSID used to authenticate is used in request.
		*/
		public void set_SubAccountSID(String value) {
			this.setInput("SubAccountSID", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) The destination phone number. Format with a '+' and country code e.g., +16175551212.
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SendSMS Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SendSMSResultSet extends ResultSet {
		public SendSMSResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The Twilio response.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
