package com.temboo.Library.Twilio.SMSMessages;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListMessages

Retrieves a list of SMS messages from your Twilio account.
*/
public class ListMessages extends Choreography {

	/**
	Create a new instance of the ListMessages Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListMessages(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/SMSMessages/ListMessages"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListMessagesInputSet
	*/
	public ListMessagesInputSet newInputSet() {
		return new ListMessagesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListMessagesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListMessagesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListMessages
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListMessagesInputSet extends InputSet {
		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the DateSent input for this Choreo. 

		@param String - (optional, date) A date in YYYY-MM-DD format. If you use this input, the Choreo will retrieve only messages sent on this date.
		*/
		public void set_DateSent(String value) {
			this.setInput("DateSent", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (optional, string) If used, the Choreo will only retrieve messages sent from this phone number.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to retrieve. Defaults to 0.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to retrieve. Defaults to 0.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PageSize input for this Choreo. 

		@param Integer - (optional, integer) The number of results per page.
		*/
		public void set_PageSize(Integer value) {
			this.setInput("PageSize", value);
		}

		/** 
		Set the value of the PageSize input for this Choreo as a String. 

		@param String - (optional, integer) The number of results per page.
		*/
		public void set_PageSize(String value) {
			this.setInput("PageSize", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ReturnLegacyFormat input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, the response will be formatted using the deprecated /SMS/Messages resource schema. This should only be used if you have existing code that relies on the older schema.
		*/
		public void set_ReturnLegacyFormat(Boolean value) {
			this.setInput("ReturnLegacyFormat", value);
		}

		/** 
		Set the value of the ReturnLegacyFormat input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, the response will be formatted using the deprecated /SMS/Messages resource schema. This should only be used if you have existing code that relies on the older schema.
		*/
		public void set_ReturnLegacyFormat(String value) {
			this.setInput("ReturnLegacyFormat", value);	
		}
		/** 
		Set the value of the SubAccountSID input for this Choreo. 

		@param String - (optional, string) The SID of the subaccount to retrieve the message from. If not specified, the main AccountSID used to authenticate is used in request.
		*/
		public void set_SubAccountSID(String value) {
			this.setInput("SubAccountSID", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (optional, string) If used, the Choreo will only retrieve messages sent to this phone number.
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListMessages Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListMessagesResultSet extends ResultSet {
		public ListMessagesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Twilio.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
