package com.temboo.Library.Stripe.Customers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateCustomerWithToken

Creates a new customer record using a Stripe generated token that represents the customer's credit card information.
*/
public class CreateCustomerWithToken extends Choreography {

	/**
	Create a new instance of the CreateCustomerWithToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateCustomerWithToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/Customers/CreateCustomerWithToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateCustomerWithTokenInputSet
	*/
	public CreateCustomerWithTokenInputSet newInputSet() {
		return new CreateCustomerWithTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateCustomerWithTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateCustomerWithTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateCustomerWithToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateCustomerWithTokenInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Stripe
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccountBalance input for this Choreo. 

		@param Integer - (optional, integer) The amount in cents for the starting account balance. A negative amount represents a credit that will be used before charging the customer's card; a positive amount will be added to the next invoice.
		*/
		public void set_AccountBalance(Integer value) {
			this.setInput("AccountBalance", value);
		}

		/** 
		Set the value of the AccountBalance input for this Choreo as a String. 

		@param String - (optional, integer) The amount in cents for the starting account balance. A negative amount represents a credit that will be used before charging the customer's card; a positive amount will be added to the next invoice.
		*/
		public void set_AccountBalance(String value) {
			this.setInput("AccountBalance", value);	
		}
		/** 
		Set the value of the Coupon input for this Choreo. 

		@param String - (optional, string) If you provide a coupon code, it can be specified here
		*/
		public void set_Coupon(String value) {
			this.setInput("Coupon", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) An arbitrary string of text that will be associated with the customer object
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) The customer's email address
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Plan input for this Choreo. 

		@param String - (optional, string) The unique identifier of the plan to subscribe the customer to
		*/
		public void set_Plan(String value) {
			this.setInput("Plan", value);
		}


		/** 
		Set the value of the Quantity input for this Choreo. 

		@param Integer - (optional, integer) The quantity you'd like to apply to the subscription you're creating. This parameter applies to the plan amount associated with the customer.
		*/
		public void set_Quantity(Integer value) {
			this.setInput("Quantity", value);
		}

		/** 
		Set the value of the Quantity input for this Choreo as a String. 

		@param String - (optional, integer) The quantity you'd like to apply to the subscription you're creating. This parameter applies to the plan amount associated with the customer.
		*/
		public void set_Quantity(String value) {
			this.setInput("Quantity", value);	
		}
		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (conditional, string) The token associated with a set of credit card details
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


		/** 
		Set the value of the TrialEnd input for this Choreo. 

		@param String - (optional, date) Epoch timestamp in seconds for the end of the trial period. The customer won't be charged during the trial period. Timestamp should be in UTC.
		*/
		public void set_TrialEnd(String value) {
			this.setInput("TrialEnd", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateCustomerWithToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateCustomerWithTokenResultSet extends ResultSet {
		public CreateCustomerWithTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Stripe
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
