package com.temboo.Library.SendGrid.WebAPI.Statistics;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetAllTimeCategoryTotals

Obtain statistics by specified categories.
*/
public class GetAllTimeCategoryTotals extends Choreography {

	/**
	Create a new instance of the GetAllTimeCategoryTotals Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetAllTimeCategoryTotals(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SendGrid/WebAPI/Statistics/GetAllTimeCategoryTotals"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetAllTimeCategoryTotalsInputSet
	*/
	public GetAllTimeCategoryTotalsInputSet newInputSet() {
		return new GetAllTimeCategoryTotalsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetAllTimeCategoryTotalsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetAllTimeCategoryTotalsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetAllTimeCategoryTotals
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetAllTimeCategoryTotalsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from SendGrid.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APIUser input for this Choreo. 

		@param String - (required, string) The username registered with SendGrid.
		*/
		public void set_APIUser(String value) {
			this.setInput("APIUser", value);
		}


		/** 
		Set the value of the Aggregate input for this Choreo. 

		@param Integer - (required, integer) Retrieve category statistics.  Default is set to 1.
		*/
		public void set_Aggregate(Integer value) {
			this.setInput("Aggregate", value);
		}

		/** 
		Set the value of the Aggregate input for this Choreo as a String. 

		@param String - (required, integer) Retrieve category statistics.  Default is set to 1.
		*/
		public void set_Aggregate(String value) {
			this.setInput("Aggregate", value);	
		}
		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (required, string) Enter a category for which statistics will be retrieved. It must be an existing category that has statistics. If the category entered does not exist, an empty result set will be returned.
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the Days input for this Choreo. 

		@param Integer - (optional, integer) The number of days (greater than 0) for which block data will be retrieved. Note that you can use either the days parameter or the start_date and end_date parameter.
		*/
		public void set_Days(Integer value) {
			this.setInput("Days", value);
		}

		/** 
		Set the value of the Days input for this Choreo as a String. 

		@param String - (optional, integer) The number of days (greater than 0) for which block data will be retrieved. Note that you can use either the days parameter or the start_date and end_date parameter.
		*/
		public void set_Days(String value) {
			this.setInput("Days", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format of the response from SendGrid, in either json, or xml.  Default is set to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, string) The start of the date range for which blocks are to be retireved. The specified date must be in YYYY-MM-DD format, and must be earlier than the EndDate variable value. Use this ,or Days.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetAllTimeCategoryTotals Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetAllTimeCategoryTotalsResultSet extends ResultSet {
		public GetAllTimeCategoryTotalsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from SendGrid. The format corresponds to the ResponseFormat input. Default is json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
