package com.temboo.Library.SendGrid.NewsletterAPI.Identity;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
EditIdentity

Edit a newsletter identity.
*/
public class EditIdentity extends Choreography {

	/**
	Create a new instance of the EditIdentity Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public EditIdentity(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SendGrid/NewsletterAPI/Identity/EditIdentity"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return EditIdentityInputSet
	*/
	public EditIdentityInputSet newInputSet() {
		return new EditIdentityInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public EditIdentityResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new EditIdentityResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the EditIdentity
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class EditIdentityInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from SendGrid.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APIUser input for this Choreo. 

		@param String - (required, string) The username registered with SendGrid. 
		*/
		public void set_APIUser(String value) {
			this.setInput("APIUser", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) The new physical address to be used for this Identity.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (required, string) The new city for this Identity.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the Country input for this Choreo. 

		@param String - (required, string) The new country to be associated with this Identity.
		*/
		public void set_Country(String value) {
			this.setInput("Country", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) An email address to be used for this identity.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Identity input for this Choreo. 

		@param String - (required, string) The identity that is to be edited.
		*/
		public void set_Identity(String value) {
			this.setInput("Identity", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The new name to be associated with this identity.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the NewIdentity input for this Choreo. 

		@param String - (optional, string) The new name for this identity.
		*/
		public void set_NewIdentity(String value) {
			this.setInput("NewIdentity", value);
		}


		/** 
		Set the value of the ReplyTo input for this Choreo. 

		@param String - (required, string) An email address to be used in the Reply-To field.
		*/
		public void set_ReplyTo(String value) {
			this.setInput("ReplyTo", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format of the response from SendGrid: Soecify json, or xml.  Default is set to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (required, string) The state to be associated with this Identity.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param Integer - (required, integer) The new zip code associated with this Identity.
		*/
		public void set_Zip(Integer value) {
			this.setInput("Zip", value);
		}

		/** 
		Set the value of the Zip input for this Choreo as a String. 

		@param String - (required, integer) The new zip code associated with this Identity.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);	
		}
		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the EditIdentity Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class EditIdentityResultSet extends ResultSet {
		public EditIdentityResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from SendGrid. The format corresponds to the ResponseFormat input. Default is json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
