package com.temboo.Library.RunKeeper.Sleep;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveLatestEntry

Returns the latest entry from a user's sleep history.
*/
public class RetrieveLatestEntry extends Choreography {

	/**
	Create a new instance of the RetrieveLatestEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveLatestEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/RunKeeper/Sleep/RetrieveLatestEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveLatestEntryInputSet
	*/
	public RetrieveLatestEntryInputSet newInputSet() {
		return new RetrieveLatestEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveLatestEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveLatestEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveLatestEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveLatestEntryInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved after the final step in the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveLatestEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveLatestEntryResultSet extends ResultSet {
		public RetrieveLatestEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Timestamp" output from this Choreo execution

		@return String - (date) The timestamp of the sleep entry.
		*/
		public String get_Timestamp() {
			return this.getResultString("Timestamp");
		}
		/** 
		Retrieve the value for the "TotalSleep" output from this Choreo execution

		@return String - (decimal) The total amount of sleep measured for the latest entry (in minutes).
		*/
		public String get_TotalSleep() {
			return this.getResultString("TotalSleep");
		}
		/** 
		Retrieve the value for the "URI" output from this Choreo execution

		@return String - (string) The URI of the sleep entry.
		*/
		public String get_URI() {
			return this.getResultString("URI");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from RunKeeper.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
