package com.temboo.Library.OneLogin.Accounts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateAccount

Creates a new account.
*/
public class CreateAccount extends Choreography {

	/**
	Create a new instance of the CreateAccount Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateAccount(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/OneLogin/Accounts/CreateAccount"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateAccountInputSet
	*/
	public CreateAccountInputSet newInputSet() {
		return new CreateAccountInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateAccountResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateAccountResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateAccount
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateAccountInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by OneLogin.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) The account name.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (optional, string) The street address for the new account.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The city associated with the address.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the Country input for this Choreo. 

		@param String - (optional, string) The country associated with the address of the new account.
		*/
		public void set_Country(String value) {
			this.setInput("Country", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address for the new account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (required, string) The first name on the new account.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (required, string) The last name on the new account.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the Phone input for this Choreo. 

		@param String - (optional, string) The phone number for the new account.
		*/
		public void set_Phone(String value) {
			this.setInput("Phone", value);
		}


		/** 
		Set the value of the Plan input for this Choreo. 

		@param String - (required, string) Indicates which plan the new account has (i.e. enterprise).
		*/
		public void set_Plan(String value) {
			this.setInput("Plan", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) The state associated with the address of the new account.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param String - (optional, string) The postal code associated with the address of the new account.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateAccount Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateAccountResultSet extends ResultSet {
		public CreateAccountResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from OneLogin.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
