package com.temboo.Library.NYTimes.TimesNewswire;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetNewsItem

Queries the Newswire API for a specific news item.
*/
public class GetNewsItem extends Choreography {

	/**
	Create a new instance of the GetNewsItem Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetNewsItem(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/TimesNewswire/GetNewsItem"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetNewsItemInputSet
	*/
	public GetNewsItemInputSet newInputSet() {
		return new GetNewsItemInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetNewsItemResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetNewsItemResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetNewsItem
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetNewsItemInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (required, string) The complete URL of a specific news item. This URL is returned in the output of the GetRecentNews Choreo.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetNewsItem Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetNewsItemResultSet extends ResultSet {
		public GetNewsItemResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
