package com.temboo.Library.NYTimes.MovieReviews;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetPicks

Retrieves lists of reviews and NYT Critics' Picks.
*/
public class GetPicks extends Choreography {

	/**
	Create a new instance of the GetPicks Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetPicks(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/MovieReviews/GetPicks"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetPicksInputSet
	*/
	public GetPicksInputSet newInputSet() {
		return new GetPicksInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetPicksResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetPicksResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetPicks
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetPicksInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) A numeric value indicating the starting point of the result set. Used to page through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) A numeric value indicating the starting point of the result set. Used to page through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Order input for this Choreo. 

		@param String - (optional, string) Sets the sort order of the results. Accepted values are: by-title, by-publication-date, by-opening-date, by-dvd-release-date.
		*/
		public void set_Order(String value) {
			this.setInput("Order", value);
		}


		/** 
		Set the value of the ResourceType input for this Choreo. 

		@param String - (optional, string) Specify "picks" to get NYT Critics' Picks in theaters or "dvd-picks" to get NYT Critics' Picks on DVD. Specify "all" to retrieve all reviews.
		*/
		public void set_ResourceType(String value) {
			this.setInput("ResourceType", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetPicks Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetPicksResultSet extends ResultSet {
		public GetPicksResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
