package com.temboo.Library.NPR.StoryFinder;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Programs

Retrieves a list of NPR programs and corresponding IDs. Also used to look up the IDs of specific NPR programs by specifying them as an optional parameter.
*/
public class Programs extends Choreography {

	/**
	Create a new instance of the Programs Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Programs(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NPR/StoryFinder/Programs"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ProgramsInputSet
	*/
	public ProgramsInputSet newInputSet() {
		return new ProgramsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ProgramsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ProgramsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Programs
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ProgramsInputSet extends InputSet {
		/** 
		Set the value of the Program input for this Choreo. 

		@param String - (optional, string) The specific program title to return. Multiple prorgam titles can be specified separated by commas (i.e. All Things Considered,Tell Me More). Program IDs are returned when this input is used.
		*/
		public void set_Program(String value) {
			this.setInput("Program", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are xml (the default), and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the StoryCountAll input for this Choreo. 

		@param Integer - (optional, integer) Returns only items with at least this number of associated stories.
		*/
		public void set_StoryCountAll(Integer value) {
			this.setInput("StoryCountAll", value);
		}

		/** 
		Set the value of the StoryCountAll input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items with at least this number of associated stories.
		*/
		public void set_StoryCountAll(String value) {
			this.setInput("StoryCountAll", value);	
		}
		/** 
		Set the value of the StoryCountMonth input for this Choreo. 

		@param Integer - (optional, integer) Returns only items with at least this number of associated stories published in the last month.
		*/
		public void set_StoryCountMonth(Integer value) {
			this.setInput("StoryCountMonth", value);
		}

		/** 
		Set the value of the StoryCountMonth input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items with at least this number of associated stories published in the last month.
		*/
		public void set_StoryCountMonth(String value) {
			this.setInput("StoryCountMonth", value);	
		}
		/** 
		Set the value of the StoryCountToday input for this Choreo. 

		@param Integer - (optional, integer) Returns only items with at least this number of associated stories published today.
		*/
		public void set_StoryCountToday(Integer value) {
			this.setInput("StoryCountToday", value);
		}

		/** 
		Set the value of the StoryCountToday input for this Choreo as a String. 

		@param String - (optional, integer) Returns only items with at least this number of associated stories published today.
		*/
		public void set_StoryCountToday(String value) {
			this.setInput("StoryCountToday", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Programs Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ProgramsResultSet extends ResultSet {
		public ProgramsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Id" output from this Choreo execution

		@return String - (integer) The ID of the program. This is only returned when the Program input is specified. When multiple programs are specified, this will be a list of IDs separated by commas.
		*/
		public String get_Id() {
			return this.getResultString("Id");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from NPR.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
