package com.temboo.Library.Microsoft.Excel.Table;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateTableRow

Creates new rows in a table.
*/
public class CreateTableRow extends Choreography {

	/**
	Create a new instance of the CreateTableRow Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateTableRow(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/Excel/Table/CreateTableRow"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateTableRowInputSet
	*/
	public CreateTableRowInputSet newInputSet() {
		return new CreateTableRowInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateTableRowResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateTableRowResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateTableRow
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateTableRowInputSet extends InputSet {
		/** 
		Set the value of the Values input for this Choreo. 

		@param String - (required, json) This is an array of arrays. The outer array can represent one or more rows while the inner array can represent one or more cell values. See Choreo notes below for more details.
		*/
		public void set_Values(String value) {
			this.setInput("Values", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) Indicates that the row should be created at this index.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) Indicates that the row should be created at this index.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the ItemPath input for this Choreo. 

		@param String - (required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
		*/
		public void set_ItemPath(String value) {
			this.setInput("ItemPath", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Table input for this Choreo. 

		@param String - (required, string) The name or id of the table to write to (e.g. Table1).
		*/
		public void set_Table(String value) {
			this.setInput("Table", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the Worksheet input for this Choreo. 

		@param String - (required, string) The name or id of the worksheet to write to (e.g. Sheet1).
		*/
		public void set_Worksheet(String value) {
			this.setInput("Worksheet", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateTableRow Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateTableRowResultSet extends ResultSet {
		public CreateTableRowResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Microsoft.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
