package com.temboo.Library.LinkedIn.Companies;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListCompanies

Returns a list of all of the companies that the authenticated user is currently configured to be an administrator of.
*/
public class ListCompanies extends Choreography {

	/**
	Create a new instance of the ListCompanies Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListCompanies(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LinkedIn/Companies/ListCompanies"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListCompaniesInputSet
	*/
	public ListCompaniesInputSet newInputSet() {
		return new ListCompaniesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListCompaniesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListCompaniesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListCompanies
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListCompaniesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by LinkedIn (AKA the Client ID).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return in the response.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return in the response.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SecretKey input for this Choreo. 

		@param String - (required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
		*/
		public void set_SecretKey(String value) {
			this.setInput("SecretKey", value);
		}


		/** 
		Set the value of the Start input for this Choreo. 

		@param Integer - (optional, integer) The page index to return. Used in combination with the Count input to page through results.
		*/
		public void set_Start(Integer value) {
			this.setInput("Start", value);
		}

		/** 
		Set the value of the Start input for this Choreo as a String. 

		@param String - (optional, integer) The page index to return. Used in combination with the Count input to page through results.
		*/
		public void set_Start(String value) {
			this.setInput("Start", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListCompanies Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListCompaniesResultSet extends ResultSet {
		public ListCompaniesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LinkedIn.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
