package com.temboo.Library.LinkedIn.Companies;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetFollowers

Returns a company's followers, by segment.
*/
public class GetFollowers extends Choreography {

	/**
	Create a new instance of the GetFollowers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetFollowers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LinkedIn/Companies/GetFollowers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetFollowersInputSet
	*/
	public GetFollowersInputSet newInputSet() {
		return new GetFollowersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetFollowersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetFollowersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetFollowers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetFollowersInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by LinkedIn (AKA the Client ID).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the CompanyID input for this Choreo. 

		@param Integer - (required, integer) A LinkedIn assigned ID associated with the company.
		*/
		public void set_CompanyID(Integer value) {
			this.setInput("CompanyID", value);
		}

		/** 
		Set the value of the CompanyID input for this Choreo as a String. 

		@param String - (required, integer) A LinkedIn assigned ID associated with the company.
		*/
		public void set_CompanyID(String value) {
			this.setInput("CompanyID", value);	
		}
		/** 
		Set the value of the CompanySizes input for this Choreo. 

		@param String - (optional, string) Used to segment by a particular company size targeting code. See Choreo notes for more details.
		*/
		public void set_CompanySizes(String value) {
			this.setInput("CompanySizes", value);
		}


		/** 
		Set the value of the GeographicArea input for this Choreo. 

		@param String - (optional, string) Used to segment by a particular geographic area. See Choreo notes for more details.
		*/
		public void set_GeographicArea(String value) {
			this.setInput("GeographicArea", value);
		}


		/** 
		Set the value of the Industries input for this Choreo. 

		@param String - (optional, string) Used to segment by member industry. See Choreo notes for more details.
		*/
		public void set_Industries(String value) {
			this.setInput("Industries", value);
		}


		/** 
		Set the value of the JobFunction input for this Choreo. 

		@param String - (optional, string) Used to segment by member job function targeting code. See Choreo notes for more details.
		*/
		public void set_JobFunction(String value) {
			this.setInput("JobFunction", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SecretKey input for this Choreo. 

		@param String - (required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
		*/
		public void set_SecretKey(String value) {
			this.setInput("SecretKey", value);
		}


		/** 
		Set the value of the SeniorityLevel input for this Choreo. 

		@param String - (optional, string) Used to segment by member seniority level targeting code. See Choreo notes for more details.
		*/
		public void set_SeniorityLevel(String value) {
			this.setInput("SeniorityLevel", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetFollowers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetFollowersResultSet extends ResultSet {
		public GetFollowersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LinkedIn.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
