package com.temboo.Library.Labs.GetPlaces;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ByFoursquare

Retrieves information from multiple APIs about places near a set of coordinates retrieved from Foursquare.
*/
public class ByFoursquare extends Choreography {

	/**
	Create a new instance of the ByFoursquare Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ByFoursquare(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Labs/GetPlaces/ByFoursquare"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ByFoursquareInputSet
	*/
	public ByFoursquareInputSet newInputSet() {
		return new ByFoursquareInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ByFoursquareResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ByFoursquareResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ByFoursquare
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ByFoursquareInputSet extends InputSet {
		/** 
		Set the value of the APICredentials input for this Choreo. 

		@param String - (required, json) A JSON dictionary of credentials for the APIs you wish to access. See Choreo documentation for formatting examples.
		*/
		public void set_APICredentials(String value) {
			this.setInput("APICredentials", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Limits the number of Foursquare venues returned.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Limits the number of Foursquare venues returned.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) This keyword input can be used to narrow search results for Google Places and Foursquare.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Shout input for this Choreo. 

		@param String - (optional, string) A message about your check-in. The maximum length of this field is 140 characters.
		*/
		public void set_Shout(String value) {
			this.setInput("Shout", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) Filters results by type of place, such as: bar, dentist, etc. This is used to filter results for Google Places and Yelp.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the VenueID input for this Choreo. 

		@param String - (optional, string) The venue where the user is checking in. Required if creating a Foursquare checkin.
		*/
		public void set_VenueID(String value) {
			this.setInput("VenueID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ByFoursquare Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ByFoursquareResultSet extends ResultSet {
		public ByFoursquareResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) Contains weather information based on the coordinates returned from the Foursquare checkin.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
