package com.temboo.Library.Kiva.Teams;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTeamByShortname

Returns detailed information about one or more teams, using team shortnames.
*/
public class GetTeamByShortname extends Choreography {

	/**
	Create a new instance of the GetTeamByShortname Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTeamByShortname(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Kiva/Teams/GetTeamByShortname"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTeamByShortnameInputSet
	*/
	public GetTeamByShortnameInputSet newInputSet() {
		return new GetTeamByShortnameInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTeamByShortnameResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTeamByShortnameResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTeamByShortname
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTeamByShortnameInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Your unique application ID, usually in reverse DNS notation.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Output returned can be XML or JSON. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the TeamShortname input for this Choreo. 

		@param String - (required, string) The Team shortname for which to return details.
		*/
		public void set_TeamShortname(String value) {
			this.setInput("TeamShortname", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTeamByShortname Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTeamByShortnameResultSet extends ResultSet {
		public GetTeamByShortnameResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Kiva.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
