package com.temboo.Library.Kiva.Loans;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchLoans

Returns a keyword search for loan listings by multiple criteria.
*/
public class SearchLoans extends Choreography {

	/**
	Create a new instance of the SearchLoans Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchLoans(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Kiva/Loans/SearchLoans"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchLoansInputSet
	*/
	public SearchLoansInputSet newInputSet() {
		return new SearchLoansInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchLoansResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchLoansResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchLoans
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchLoansInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Your unique application ID, usually in reverse DNS notation.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (optional, string) A list of two-character ISO codes of countries by which to filter results.
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Gender input for this Choreo. 

		@param String - (optional, string) If supplied, results are filtered to loans with entrepreneurs of the specified gender. In the case of group loans, this matches against the predominate gender in the group: male or female.
		*/
		public void set_Gender(String value) {
			this.setInput("Gender", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page position of results to return. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page position of results to return. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Partner input for this Choreo. 

		@param String - (optional, string) A list of partner IDs for which to filter results.
		*/
		public void set_Partner(String value) {
			this.setInput("Partner", value);
		}


		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) A query string against which results should be returned.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the Region input for this Choreo. 

		@param String - (optional, string) List of two-letter codes corresponding to regions in which Kiva operates. If supplied, results are filtered to loans only from the specified regions: na, ca, sa, af, as, me, ee.
		*/
		public void set_Region(String value) {
			this.setInput("Region", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Output returned can be XML or JSON. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Sector input for this Choreo. 

		@param String - (optional, string) A list of business sectors for which to filter results.
		*/
		public void set_Sector(String value) {
			this.setInput("Sector", value);
		}


		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) The order by which to sort results. Acceptable values: popularity, loan_amount, oldest, expiration, newest, amount_remaining, repayment_term. Defaults to newest.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the Status input for this Choreo. 

		@param String - (optional, string) The status of loans to return: fundraising, funded, in_repayment, paid, ended_with_loss.
		*/
		public void set_Status(String value) {
			this.setInput("Status", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchLoans Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchLoansResultSet extends ResultSet {
		public SearchLoansResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Kiva.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
