package com.temboo.Library.Kiva.Lenders;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchLenders

Returns a keyword search for lenders based on multiple criteria.
*/
public class SearchLenders extends Choreography {

	/**
	Create a new instance of the SearchLenders Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchLenders(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Kiva/Lenders/SearchLenders"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchLendersInputSet
	*/
	public SearchLendersInputSet newInputSet() {
		return new SearchLendersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchLendersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchLendersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchLenders
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchLendersInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Your unique application ID, usually in reverse DNS notation.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (optional, string) An ISO country code by which to filter results.
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page position of results to return. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page position of results to return. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (conditional, string) A general search query parameter which matches against lenders’ names occupations, whereabouts, and reasons for lending.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Output returned can be XML or JSON. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) The order by which to sort results. Acceptable values: oldest, newest. Defaults to newest.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchLenders Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchLendersResultSet extends ResultSet {
		public SearchLendersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Kiva.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
