package com.temboo.Library.InfluenceExplorer;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CampaignContribution

Retrieve detailed information on political campaign contributions, filtered by date, contributor, state, employer, campaign, etc.
*/
public class CampaignContribution extends Choreography {

	/**
	Create a new instance of the CampaignContribution Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CampaignContribution(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/InfluenceExplorer/CampaignContribution"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CampaignContributionInputSet
	*/
	public CampaignContributionInputSet newInputSet() {
		return new CampaignContributionInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CampaignContributionResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CampaignContributionResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CampaignContribution
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CampaignContributionInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API key provided by Sunlight Data Services.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Amount input for this Choreo. 

		@param String - (conditional, string) Enter the amount of dollars spent on lobbying.  Valid formats include: 500 (exactly $500); >|500 (greater than, or equal to 500); <|500 (less than or equal to 500).
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);
		}


		/** 
		Set the value of the ContributorName input for this Choreo. 

		@param String - (conditional, string) Specfiy the name of an individual, PAC, organization, or employer for which a full-text search will be performed.
		*/
		public void set_ContributorName(String value) {
			this.setInput("ContributorName", value);
		}


		/** 
		Set the value of the ContributorsByState input for this Choreo. 

		@param String - (conditional, string) Enter a two-letter state designation from which the contribution is made.
		*/
		public void set_ContributorsByState(String value) {
			this.setInput("ContributorsByState", value);
		}


		/** 
		Set the value of the Cycle input for this Choreo. 

		@param String - (conditional, string) Specify a yyyy-formatted election cycle. Example: 2012, or 2008|2012 to limit results between 2008 and 2012.
		*/
		public void set_Cycle(String value) {
			this.setInput("Cycle", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (conditional, string) Specify a date of the contribution in ISO date format.  For example: 2006-08-06.  Or, ><|2006-08-06|2006-09-12 to limit results between specific dates.
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the OrganizationName input for this Choreo. 

		@param String - (conditional, string) Specify a full-text search on employer, organization, and parent organization.
		*/
		public void set_OrganizationName(String value) {
			this.setInput("OrganizationName", value);
		}


		/** 
		Set the value of the RecipientName input for this Choreo. 

		@param String - (conditional, string) Enter the full-text search on name of PAC or candidate receiving the contribution.
		*/
		public void set_RecipientName(String value) {
			this.setInput("RecipientName", value);
		}


		/** 
		Set the value of the RecipientState input for this Choreo. 

		@param String - (conditional, string) Specify a two-letter state abbreviation for the state in which the recipient of contributions is running a campaign.
		*/
		public void set_RecipientState(String value) {
			this.setInput("RecipientState", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Indicates the desired format for the response. Accepted values are: json (the default), csv, and xls. Note when specifying xls, restults are returned as Base64 encoded data.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Seat input for this Choreo. 

		@param String - (conditional, string) Specify the type of political office being sought.  Examples: federal:senate (US Senate), federal:president (US President), state:governor.  For more info see documentation.
		*/
		public void set_Seat(String value) {
			this.setInput("Seat", value);
		}


		/** 
		Set the value of the TransactionNamespace input for this Choreo. 

		@param String - (optional, string) Filters on federal or state contributions. Valid namespaces are: urn:fec:transaction (for federal) or urn:nimsp:transaction (for state).
		*/
		public void set_TransactionNamespace(String value) {
			this.setInput("TransactionNamespace", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CampaignContribution Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CampaignContributionResultSet extends ResultSet {
		public CampaignContributionResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Influence Explorer. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
