package com.temboo.Library.GitHub.IssuesAPI.Issues;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListYourIssues

Lists all issues associated with the provided access token.
*/
public class ListYourIssues extends Choreography {

	/**
	Create a new instance of the ListYourIssues Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListYourIssues(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/IssuesAPI/Issues/ListYourIssues"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListYourIssuesInputSet
	*/
	public ListYourIssuesInputSet newInputSet() {
		return new ListYourIssuesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListYourIssuesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListYourIssuesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListYourIssues
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListYourIssuesInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Direction input for this Choreo. 

		@param String - (optional, string) The direction of the sort order. Valid values are: asc or desc (the default).
		*/
		public void set_Direction(String value) {
			this.setInput("Direction", value);
		}


		/** 
		Set the value of the Filter input for this Choreo. 

		@param String - (optional, string) Filters issues using one of the following strings: assigned (the default), created, mentioned, subscribed.
		*/
		public void set_Filter(String value) {
			this.setInput("Filter", value);
		}


		/** 
		Set the value of the Labels input for this Choreo. 

		@param String - (optional, string) A comma separated list of label names (i.e. bug, ui, etc).
		*/
		public void set_Labels(String value) {
			this.setInput("Labels", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Indicates the page index that you want to retrieve. This is used to page through many results. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Indicates the page index that you want to retrieve. This is used to page through many results. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (optional, date) A timestamp in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ). Returns issues since this date.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Indicates how the issues will be sorted in the response. Valid sort options are: created (the default), updated, comments.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Returns issues with a particular state: open (the default) or closed.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListYourIssues Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListYourIssuesResultSet extends ResultSet {
		public ListYourIssuesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FirstPage" output from this Choreo execution

		@return String - (integer) The index for the first page of results.
		*/
		public String get_FirstPage() {
			return this.getResultString("FirstPage");
		}
		/** 
		Retrieve the value for the "LastPage" output from this Choreo execution

		@return String - (integer) The index for the last page of results.
		*/
		public String get_LastPage() {
			return this.getResultString("LastPage");
		}
		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "NextPage" output from this Choreo execution

		@return String - (integer) The index for the next page of results.
		*/
		public String get_NextPage() {
			return this.getResultString("NextPage");
		}
		/** 
		Retrieve the value for the "PreviousPage" output from this Choreo execution

		@return String - (integer) The index for the previous page of results.
		*/
		public String get_PreviousPage() {
			return this.getResultString("PreviousPage");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
