package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTimeOfUseGroup

Returns a particular Time of Use Group with a given touGroupId and lseId.
*/
public class GetTimeOfUseGroup extends Choreography {

	/**
	Create a new instance of the GetTimeOfUseGroup Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTimeOfUseGroup(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetTimeOfUseGroup"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTimeOfUseGroupInputSet
	*/
	public GetTimeOfUseGroupInputSet newInputSet() {
		return new GetTimeOfUseGroupInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTimeOfUseGroupResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTimeOfUseGroupResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTimeOfUseGroup
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTimeOfUseGroupInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the EndsWith input for this Choreo. 

		@param String - (optional, string) When true, the search will only return results that end with the specified search string. Otherwise, any match of the search string will be returned as a result.
		*/
		public void set_EndsWith(String value) {
			this.setInput("EndsWith", value);
		}


		/** 
		Set the value of the IsRegex input for this Choreo. 

		@param Boolean - (optional, boolean) When true, the provided search string will be regarded as a regular expression and the search will return results matching the regular expression.
		*/
		public void set_IsRegex(Boolean value) {
			this.setInput("IsRegex", value);
		}

		/** 
		Set the value of the IsRegex input for this Choreo as a String. 

		@param String - (optional, boolean) When true, the provided search string will be regarded as a regular expression and the search will return results matching the regular expression.
		*/
		public void set_IsRegex(String value) {
			this.setInput("IsRegex", value);	
		}
		/** 
		Set the value of the LSEID input for this Choreo. 

		@param Integer - (conditional, integer) Used to retrieve a TOU Group for a specific LSE.
		*/
		public void set_LSEID(Integer value) {
			this.setInput("LSEID", value);
		}

		/** 
		Set the value of the LSEID input for this Choreo as a String. 

		@param String - (conditional, integer) Used to retrieve a TOU Group for a specific LSE.
		*/
		public void set_LSEID(String value) {
			this.setInput("LSEID", value);	
		}
		/** 
		Set the value of the PageCount input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(Integer value) {
			this.setInput("PageCount", value);
		}

		/** 
		Set the value of the PageCount input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(String value) {
			this.setInput("PageCount", value);	
		}
		/** 
		Set the value of the PageStart input for this Choreo. 

		@param Integer - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(Integer value) {
			this.setInput("PageStart", value);
		}

		/** 
		Set the value of the PageStart input for this Choreo as a String. 

		@param String - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(String value) {
			this.setInput("PageStart", value);	
		}
		/** 
		Set the value of the Search input for this Choreo. 

		@param String - (optional, string) The string of text to search on. This can also be a regular expression, in which case you should set the 'isRegex' flag to true.
		*/
		public void set_Search(String value) {
			this.setInput("Search", value);
		}


		/** 
		Set the value of the SearchOn input for this Choreo. 

		@param String - (optional, string) Comma separated list of fields to query on. When searchOn is specified, the text provided in the search string field will be searched within these fields.
		*/
		public void set_SearchOn(String value) {
			this.setInput("SearchOn", value);
		}


		/** 
		Set the value of the SortOn input for this Choreo. 

		@param String - (optional, string) Comma separated list of fields to sort on.
		*/
		public void set_SortOn(String value) {
			this.setInput("SortOn", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Comma separated list of ordering. Possible values are 'ASC' and 'DESC'. Default is 'ASC'. This list corresponds to the field list used in the SortOn input.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the StartsWith input for this Choreo. 

		@param Boolean - (optional, boolean) When true, the search will only return results that begin with the specified search string. Otherwise, any match of the search string will be returned as a result.
		*/
		public void set_StartsWith(Boolean value) {
			this.setInput("StartsWith", value);
		}

		/** 
		Set the value of the StartsWith input for this Choreo as a String. 

		@param String - (optional, boolean) When true, the search will only return results that begin with the specified search string. Otherwise, any match of the search string will be returned as a result.
		*/
		public void set_StartsWith(String value) {
			this.setInput("StartsWith", value);	
		}
		/** 
		Set the value of the TOUGroupID input for this Choreo. 

		@param Integer - (conditional, integer) Used to retrieve a TOU Group by its ID (required when LSE ID is provided).
		*/
		public void set_TOUGroupID(Integer value) {
			this.setInput("TOUGroupID", value);
		}

		/** 
		Set the value of the TOUGroupID input for this Choreo as a String. 

		@param String - (conditional, integer) Used to retrieve a TOU Group by its ID (required when LSE ID is provided).
		*/
		public void set_TOUGroupID(String value) {
			this.setInput("TOUGroupID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTimeOfUseGroup Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTimeOfUseGroupResultSet extends ResultSet {
		public GetTimeOfUseGroupResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
