package com.temboo.Library.Foursquare.Specials;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchSpecials

Returns a list of specials near the current location.
*/
public class SearchSpecials extends Choreography {

	/**
	Create a new instance of the SearchSpecials Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchSpecials(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Specials/SearchSpecials"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchSpecialsInputSet
	*/
	public SearchSpecialsInputSet newInputSet() {
		return new SearchSpecialsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchSpecialsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchSpecialsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchSpecials
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchSpecialsInputSet extends InputSet {
		/** 
		Set the value of the AccuracyOfCoordinates input for this Choreo. 

		@param Integer - (optional, integer) Accuracy of latitude and longitude, in meters.
		*/
		public void set_AccuracyOfCoordinates(Integer value) {
			this.setInput("AccuracyOfCoordinates", value);
		}

		/** 
		Set the value of the AccuracyOfCoordinates input for this Choreo as a String. 

		@param String - (optional, integer) Accuracy of latitude and longitude, in meters.
		*/
		public void set_AccuracyOfCoordinates(String value) {
			this.setInput("AccuracyOfCoordinates", value);	
		}
		/** 
		Set the value of the Altitude input for this Choreo. 

		@param Integer - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(Integer value) {
			this.setInput("Altitude", value);
		}

		/** 
		Set the value of the Altitude input for this Choreo as a String. 

		@param String - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(String value) {
			this.setInput("Altitude", value);	
		}
		/** 
		Set the value of the AltitudeAccuracy input for this Choreo. 

		@param Integer - (optional, integer) Accuracy of the user's altitude, in meters.
		*/
		public void set_AltitudeAccuracy(Integer value) {
			this.setInput("AltitudeAccuracy", value);
		}

		/** 
		Set the value of the AltitudeAccuracy input for this Choreo as a String. 

		@param String - (optional, integer) Accuracy of the user's altitude, in meters.
		*/
		public void set_AltitudeAccuracy(String value) {
			this.setInput("AltitudeAccuracy", value);	
		}
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) Your Foursquare client ID, obtained after registering at Foursquare. Required unless using the OauthToken input.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) Your Foursquare client secret, obtained after registering at Foursquare. Required unless using the OauthToken input.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Number of results to retun, up to 50.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Number of results to retun, up to 50.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (conditional, string) The Foursquare API Oauth token string. Required unless specifying the ClientID and ClientSecret.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (optional, integer) Limit results to venues within this many meters of the specified location. Defaults to a city-wide area.
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (optional, integer) Limit results to venues within this many meters of the specified location. Defaults to a city-wide area.
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchSpecials Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchSpecialsResultSet extends ResultSet {
		public SearchSpecialsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
