package com.temboo.Library.Flickr.Photos;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Download

Retrieves a photo from a constructed source URL and returns the file content as Base64 encoded data.
*/
public class Download extends Choreography {

	/**
	Create a new instance of the Download Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Download(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Flickr/Photos/Download"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DownloadInputSet
	*/
	public DownloadInputSet newInputSet() {
		return new DownloadInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DownloadResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DownloadResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Download
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DownloadInputSet extends InputSet {
		/** 
		Set the value of the FarmID input for this Choreo. 

		@param Integer - (conditional, integer) The farm id associated with the photo. Required unless providing the URL.
		*/
		public void set_FarmID(Integer value) {
			this.setInput("FarmID", value);
		}

		/** 
		Set the value of the FarmID input for this Choreo as a String. 

		@param String - (conditional, integer) The farm id associated with the photo. Required unless providing the URL.
		*/
		public void set_FarmID(String value) {
			this.setInput("FarmID", value);	
		}
		/** 
		Set the value of the ImageType input for this Choreo. 

		@param String - (optional, string) The image type. Valid values are: jpg, png, or gif. Defaults to "jpg".
		*/
		public void set_ImageType(String value) {
			this.setInput("ImageType", value);
		}


		/** 
		Set the value of the PhotoID input for this Choreo. 

		@param Integer - (conditional, integer) The id of the photo you to download.
		*/
		public void set_PhotoID(Integer value) {
			this.setInput("PhotoID", value);
		}

		/** 
		Set the value of the PhotoID input for this Choreo as a String. 

		@param String - (conditional, integer) The id of the photo you to download.
		*/
		public void set_PhotoID(String value) {
			this.setInput("PhotoID", value);	
		}
		/** 
		Set the value of the Secret input for this Choreo. 

		@param String - (conditional, string) The secret associated with the photo. Required unless providing the URL.
		*/
		public void set_Secret(String value) {
			this.setInput("Secret", value);
		}


		/** 
		Set the value of the ServerID input for this Choreo. 

		@param Integer - (conditional, integer) The server id associated with the photo. Required unless providing the URL.
		*/
		public void set_ServerID(Integer value) {
			this.setInput("ServerID", value);
		}

		/** 
		Set the value of the ServerID input for this Choreo as a String. 

		@param String - (conditional, integer) The server id associated with the photo. Required unless providing the URL.
		*/
		public void set_ServerID(String value) {
			this.setInput("ServerID", value);	
		}
		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (conditional, string) The url to download the photo from. Required unless providing the Secret, ServerID, and FarmID parameters.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Download Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DownloadResultSet extends ResultSet {
		public DownloadResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The Base64 encoded image content.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
