package com.temboo.Library.Flickr.Favorites;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListPublicFavorites

Returns a list of favorite public photos for the given user.
*/
public class ListPublicFavorites extends Choreography {

	/**
	Create a new instance of the ListPublicFavorites Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListPublicFavorites(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Flickr/Favorites/ListPublicFavorites"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListPublicFavoritesInputSet
	*/
	public ListPublicFavoritesInputSet newInputSet() {
		return new ListPublicFavoritesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListPublicFavoritesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListPublicFavoritesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListPublicFavorites
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListPublicFavoritesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Flickr (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Extras input for this Choreo. 

		@param String - (optional, string) A comma-delimited list of extra information to fetch for each returned record. See Choreo documentation for accepted values.
		*/
		public void set_Extras(String value) {
			this.setInput("Extras", value);
		}


		/** 
		Set the value of the MaxFaveDate input for this Choreo. 

		@param String - (optional, date) Maximum date that a photo was favorited on. The date should be in the form of a unix timestamp.
		*/
		public void set_MaxFaveDate(String value) {
			this.setInput("MaxFaveDate", value);
		}


		/** 
		Set the value of the MinFaveDate input for this Choreo. 

		@param String - (optional, date) Minimum date that a photo was favorited on. The date should be in the form of a unix timestamp.
		*/
		public void set_MinFaveDate(String value) {
			this.setInput("MinFaveDate", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to return. Used for paging through many results.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to return. Used for paging through many results.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of photos to return per page. Defaults to 100.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of photos to return per page. Defaults to 100.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml and json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (required, string) The user to fetch the favorites list for.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListPublicFavorites Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListPublicFavoritesResultSet extends ResultSet {
		public ListPublicFavoritesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Flickr.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
