package com.temboo.Library.FedSpending;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Contracts

Allows access to the information in the Federal Procurement Data System (FPDS) database, which reports all federal contracts awarded. 
*/
public class Contracts extends Choreography {

	/**
	Create a new instance of the Contracts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Contracts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FedSpending/Contracts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ContractsInputSet
	*/
	public ContractsInputSet newInputSet() {
		return new ContractsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ContractsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ContractsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Contracts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ContractsInputSet extends InputSet {
		/** 
		Set the value of the City input for this Choreo. 

		@param String - (conditional, string) The city within a contractor's address.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the CompanyName input for this Choreo. 

		@param String - (conditional, string) The name of a a contractor or contractor parent company.
		*/
		public void set_CompanyName(String value) {
			this.setInput("CompanyName", value);
		}


		/** 
		Set the value of the Completion input for this Choreo. 

		@param String - (conditional, string) The competition status of a contract. Valid values: c=Full competition, o=Full competition, one bid, p=Competition, exclusion of sources, n=Not complete, a=Not available, f=Follow-up, u=Unknown.
		*/
		public void set_Completion(String value) {
			this.setInput("Completion", value);
		}


		/** 
		Set the value of the Detail input for this Choreo. 

		@param String - (optional, string) Controls the level of detail of the output. Acceptable values: -1 (summary), 0 (low), 1 (medium), 2 (high), and 3 (extensive). Defaults to -1. See docs for more information.
		*/
		public void set_Detail(String value) {
			this.setInput("Detail", value);
		}


		/** 
		Set the value of the FirstYearRange input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the first year in a range of years; if used, must be used with LastYearRange and without FiscalYear.
		*/
		public void set_FirstYearRange(Integer value) {
			this.setInput("FirstYearRange", value);
		}

		/** 
		Set the value of the FirstYearRange input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the first year in a range of years; if used, must be used with LastYearRange and without FiscalYear.
		*/
		public void set_FirstYearRange(String value) {
			this.setInput("FirstYearRange", value);	
		}
		/** 
		Set the value of the FiscalYear input for this Choreo. 

		@param Integer - (conditional, integer) Specifies a single year; defaults to all years.
		*/
		public void set_FiscalYear(Integer value) {
			this.setInput("FiscalYear", value);
		}

		/** 
		Set the value of the FiscalYear input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies a single year; defaults to all years.
		*/
		public void set_FiscalYear(String value) {
			this.setInput("FiscalYear", value);	
		}
		/** 
		Set the value of the LastYearRange input for this Choreo. 

		@param Integer - (conditional, integer) Specifies the last year in a range of years; if used, must be used with FirstYearRange and without FiscalYear.
		*/
		public void set_LastYearRange(Integer value) {
			this.setInput("LastYearRange", value);
		}

		/** 
		Set the value of the LastYearRange input for this Choreo as a String. 

		@param String - (conditional, integer) Specifies the last year in a range of years; if used, must be used with FirstYearRange and without FiscalYear.
		*/
		public void set_LastYearRange(String value) {
			this.setInput("LastYearRange", value);	
		}
		/** 
		Set the value of the MajAgency input for this Choreo. 

		@param String - (conditional, string) The 2-character code for a major governmental agency issuing contracts.
		*/
		public void set_MajAgency(String value) {
			this.setInput("MajAgency", value);
		}


		/** 
		Set the value of the MaxRecords input for this Choreo. 

		@param Integer - (optional, integer) Allows you to set the maximum number of records retrieved. Defaults to 100.
		*/
		public void set_MaxRecords(Integer value) {
			this.setInput("MaxRecords", value);
		}

		/** 
		Set the value of the MaxRecords input for this Choreo as a String. 

		@param String - (optional, integer) Allows you to set the maximum number of records retrieved. Defaults to 100.
		*/
		public void set_MaxRecords(String value) {
			this.setInput("MaxRecords", value);	
		}
		/** 
		Set the value of the ModAgency input for this Choreo. 

		@param String - (conditional, string) The 4-digit code for a specific governmental agency issuing contracts.
		*/
		public void set_ModAgency(String value) {
			this.setInput("ModAgency", value);
		}


		/** 
		Set the value of the PIID input for this Choreo. 

		@param Integer - (conditional, integer) A Federal ID number for the contract.
		*/
		public void set_PIID(Integer value) {
			this.setInput("PIID", value);
		}

		/** 
		Set the value of the PIID input for this Choreo as a String. 

		@param String - (conditional, integer) A Federal ID number for the contract.
		*/
		public void set_PIID(String value) {
			this.setInput("PIID", value);	
		}
		/** 
		Set the value of the PSC input for this Choreo. 

		@param String - (conditional, string) The 4-character code for a product or service.
		*/
		public void set_PSC(String value) {
			this.setInput("PSC", value);
		}


		/** 
		Set the value of the PSCCategory input for this Choreo. 

		@param String - (conditional, string) The 2-character code for a major product or service category.
		*/
		public void set_PSCCategory(String value) {
			this.setInput("PSCCategory", value);
		}


		/** 
		Set the value of the PopCountryCode input for this Choreo. 

		@param String - (conditional, string) The two-letter country code for the place of performance country.
		*/
		public void set_PopCountryCode(String value) {
			this.setInput("PopCountryCode", value);
		}


		/** 
		Set the value of the PopDistrict input for this Choreo. 

		@param String - (conditional, string) The Congressional District of the place of performance.
		*/
		public void set_PopDistrict(String value) {
			this.setInput("PopDistrict", value);
		}


		/** 
		Set the value of the PopZipCode input for this Choreo. 

		@param Integer - (conditional, integer) The ZIP code of the place of performance.
		*/
		public void set_PopZipCode(Integer value) {
			this.setInput("PopZipCode", value);
		}

		/** 
		Set the value of the PopZipCode input for this Choreo as a String. 

		@param String - (conditional, integer) The ZIP code of the place of performance.
		*/
		public void set_PopZipCode(String value) {
			this.setInput("PopZipCode", value);	
		}
		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) Determines how records are sorted. Valid values: r (contractor/recipient name), f (dollars of awards),g (major contracting agency),p (Product or Service Category),d (date of award). Defaults to f.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (conditional, string) The state abbreviation within a contractor's address.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the StateCode input for this Choreo. 

		@param String - (conditional, string) The state abbreviation of the state of the place of performance.
		*/
		public void set_StateCode(String value) {
			this.setInput("StateCode", value);
		}


		/** 
		Set the value of the TextSearch input for this Choreo. 

		@param String - (conditional, string) Free text search within the text that describes what the contract is for.
		*/
		public void set_TextSearch(String value) {
			this.setInput("TextSearch", value);
		}


		/** 
		Set the value of the VendorCountryCode input for this Choreo. 

		@param String - (conditional, string) The two-letter country code for the country in a contractor's address.
		*/
		public void set_VendorCountryCode(String value) {
			this.setInput("VendorCountryCode", value);
		}


		/** 
		Set the value of the VendorDistrict input for this Choreo. 

		@param String - (conditional, string) The 4-character Congressional District within which a contractor is located.
		*/
		public void set_VendorDistrict(String value) {
			this.setInput("VendorDistrict", value);
		}


		/** 
		Set the value of the ZipCode input for this Choreo. 

		@param Integer - (conditional, integer) The ZIP code within a contractor's address.
		*/
		public void set_ZipCode(Integer value) {
			this.setInput("ZipCode", value);
		}

		/** 
		Set the value of the ZipCode input for this Choreo as a String. 

		@param String - (conditional, integer) The ZIP code within a contractor's address.
		*/
		public void set_ZipCode(String value) {
			this.setInput("ZipCode", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Contracts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ContractsResultSet extends ResultSet {
		public ContractsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from FedSpending.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
