package com.temboo.Library.Factual;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FilterPlacesByMultipleCities

Restrict a query to a specified city.
*/
public class FilterPlacesByMultipleCities extends Choreography {

	/**
	Create a new instance of the FilterPlacesByMultipleCities Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FilterPlacesByMultipleCities(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Factual/FilterPlacesByMultipleCities"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FilterPlacesByMultipleCitiesInputSet
	*/
	public FilterPlacesByMultipleCitiesInputSet newInputSet() {
		return new FilterPlacesByMultipleCitiesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FilterPlacesByMultipleCitiesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FilterPlacesByMultipleCitiesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FilterPlacesByMultipleCities
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FilterPlacesByMultipleCitiesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The API Key provided by Factual (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (optional, string) The API Secret provided by Factual (AKA the OAuth Consumer Secret).
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Cities input for this Choreo. 

		@param String - (required, json) A A JSON-encoded array of cities to filter results by.
		*/
		public void set_Cities(String value) {
			this.setInput("Cities", value);
		}


		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) A search string (i.e. Starbucks).
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FilterPlacesByMultipleCities Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FilterPlacesByMultipleCitiesResultSet extends ResultSet {
		public FilterPlacesByMultipleCitiesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Factual.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
