package com.temboo.Library.Facebook.Publishing;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadPhoto

Uploads a photo to a given album.
*/
public class UploadPhoto extends Choreography {

	/**
	Create a new instance of the UploadPhoto Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadPhoto(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Publishing/UploadPhoto"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadPhotoInputSet
	*/
	public UploadPhotoInputSet newInputSet() {
		return new UploadPhotoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadPhotoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadPhotoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadPhoto
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadPhotoInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AlbumID input for this Choreo. 

		@param String - (optional, string) The id of the album to upload the photo to.
		*/
		public void set_AlbumID(String value) {
			this.setInput("AlbumID", value);
		}


		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (optional, string) A message to attach to the photo.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Photo input for this Choreo. 

		@param String - (conditional, string) The Base64 encoded image to upload. This is required unless using the URL input to publish the photo.
		*/
		public void set_Photo(String value) {
			this.setInput("Photo", value);
		}


		/** 
		Set the value of the Place input for this Choreo. 

		@param String - (optional, string) The ID of a location where the photo was taken.
		*/
		public void set_Place(String value) {
			this.setInput("Place", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Source input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Source(String value) {
			this.setInput("Source", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (conditional, string) A URL to a hosted photo that should be uploaded. This is required unless providing a Base64 encoded image for the Photo input.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - A path to image in the vault. This can be used as an alternative to the Photo input.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadPhoto Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadPhotoResultSet extends ResultSet {
		public UploadPhotoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
