package com.temboo.Library.Facebook.Actions.Video.WantsToWatch;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateWantsToWatch

Updates an existing wants_to_watch action.
*/
public class UpdateWantsToWatch extends Choreography {

	/**
	Create a new instance of the UpdateWantsToWatch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateWantsToWatch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Actions/Video/WantsToWatch/UpdateWantsToWatch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateWantsToWatchInputSet
	*/
	public UpdateWantsToWatchInputSet newInputSet() {
		return new UpdateWantsToWatchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateWantsToWatchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateWantsToWatchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateWantsToWatch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateWantsToWatchInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ActionID input for this Choreo. 

		@param String - (required, string) The id of the action to update.
		*/
		public void set_ActionID(String value) {
			this.setInput("ActionID", value);
		}


		/** 
		Set the value of the AiringEndTime input for this Choreo. 

		@param String - (optional, date) The time that the airing ends.
		*/
		public void set_AiringEndTime(String value) {
			this.setInput("AiringEndTime", value);
		}


		/** 
		Set the value of the AiringID input for this Choreo. 

		@param String - (optional, string) The id of the video airing.
		*/
		public void set_AiringID(String value) {
			this.setInput("AiringID", value);
		}


		/** 
		Set the value of the AiringStartTime input for this Choreo. 

		@param String - (optional, date) The time that the airing begins.
		*/
		public void set_AiringStartTime(String value) {
			this.setInput("AiringStartTime", value);
		}


		/** 
		Set the value of the EndTime input for this Choreo. 

		@param String - (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
		*/
		public void set_EndTime(String value) {
			this.setInput("EndTime", value);
		}


		/** 
		Set the value of the Episode input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing an episode of a show.
		*/
		public void set_Episode(String value) {
			this.setInput("Episode", value);
		}


		/** 
		Set the value of the ExpiresIn input for this Choreo. 

		@param Integer - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(Integer value) {
			this.setInput("ExpiresIn", value);
		}

		/** 
		Set the value of the ExpiresIn input for this Choreo as a String. 

		@param String - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(String value) {
			this.setInput("ExpiresIn", value);	
		}
		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Movie input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing a movie.
		*/
		public void set_Movie(String value) {
			this.setInput("Movie", value);
		}


		/** 
		Set the value of the Other input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing any general video content.
		*/
		public void set_Other(String value) {
			this.setInput("Other", value);
		}


		/** 
		Set the value of the Place input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
		*/
		public void set_Place(String value) {
			this.setInput("Place", value);
		}


		/** 
		Set the value of the TVShow input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing a TV show.
		*/
		public void set_TVShow(String value) {
			this.setInput("TVShow", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) A comma separated list of other profile IDs that also performed this action.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateWantsToWatch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateWantsToWatchResultSet extends ResultSet {
		public UpdateWantsToWatchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
