package com.temboo.Library.Dropbox.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadSessionAppend

Appends more data to an upload session.
*/
public class UploadSessionAppend extends Choreography {

	/**
	Create a new instance of the UploadSessionAppend Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadSessionAppend(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Files/UploadSessionAppend"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadSessionAppendInputSet
	*/
	public UploadSessionAppendInputSet newInputSet() {
		return new UploadSessionAppendInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadSessionAppendResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadSessionAppendResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadSessionAppend
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadSessionAppendInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Close input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.
		*/
		public void set_Close(Boolean value) {
			this.setInput("Close", value);
		}

		/** 
		Set the value of the Close input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.
		*/
		public void set_Close(String value) {
			this.setInput("Close", value);	
		}
		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the FileContent input for this Choreo. 

		@param String - (conditional, string) The next file segment to upload. Binary files should be Base64-encoded. Encoding is not required when ContentType is set to "text/plain".
		*/
		public void set_FileContent(String value) {
			this.setInput("FileContent", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (required, integer) The amount of data that has been uploaded so far.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (required, integer) The amount of data that has been uploaded so far.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the SessionID input for this Choreo. 

		@param String - (conditional, string) The upload session ID returned from UploadSessionStart.
		*/
		public void set_SessionID(String value) {
			this.setInput("SessionID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadSessionAppend Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadSessionAppendResultSet extends ResultSet {
		public UploadSessionAppendResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

	}
	
}
