package com.temboo.Library.Dropbox.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLatestCursor

Gets a cursor for the folder's state.
*/
public class GetLatestCursor extends Choreography {

	/**
	Create a new instance of the GetLatestCursor Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLatestCursor(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Files/GetLatestCursor"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLatestCursorInputSet
	*/
	public GetLatestCursorInputSet newInputSet() {
		return new GetLatestCursorInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLatestCursorResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLatestCursorResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLatestCursor
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLatestCursorInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the IncludeDeleted input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the results will include entries for files and folders that used to exist but were deleted. The default for this field is false.
		*/
		public void set_IncludeDeleted(Boolean value) {
			this.setInput("IncludeDeleted", value);
		}

		/** 
		Set the value of the IncludeDeleted input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the results will include entries for files and folders that used to exist but were deleted. The default for this field is false.
		*/
		public void set_IncludeDeleted(String value) {
			this.setInput("IncludeDeleted", value);	
		}
		/** 
		Set the value of the IncludeHasExplicitSharedMembers input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.
		*/
		public void set_IncludeHasExplicitSharedMembers(Boolean value) {
			this.setInput("IncludeHasExplicitSharedMembers", value);
		}

		/** 
		Set the value of the IncludeHasExplicitSharedMembers input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.
		*/
		public void set_IncludeHasExplicitSharedMembers(String value) {
			this.setInput("IncludeHasExplicitSharedMembers", value);	
		}
		/** 
		Set the value of the IncludeMediaInfo input for this Choreo. 

		@param Boolean - (optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.
		*/
		public void set_IncludeMediaInfo(Boolean value) {
			this.setInput("IncludeMediaInfo", value);
		}

		/** 
		Set the value of the IncludeMediaInfo input for this Choreo as a String. 

		@param String - (optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.
		*/
		public void set_IncludeMediaInfo(String value) {
			this.setInput("IncludeMediaInfo", value);	
		}
		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path to the folder you want to see the contents of. This should be empty to list contents at the root level.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the Recursive input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the list folder operation will be applied recursively to all subfolders and the response will contain contents of all subfolders. The default for this field is false.
		*/
		public void set_Recursive(Boolean value) {
			this.setInput("Recursive", value);
		}

		/** 
		Set the value of the Recursive input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the list folder operation will be applied recursively to all subfolders and the response will contain contents of all subfolders. The default for this field is false.
		*/
		public void set_Recursive(String value) {
			this.setInput("Recursive", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLatestCursor Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLatestCursorResultSet extends ResultSet {
		public GetLatestCursorResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Cursor" output from this Choreo execution

		@return String - (string) A cursor used to retrieve the next set of results with ListFolderContinue.
		*/
		public String get_Cursor() {
			return this.getResultString("Cursor");
		}
	}
	
}
