package com.temboo.Library.Disqus.OAuth;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
InitializeOAuth

Generates an authorization URL that an application can use to complete the first step in the OAuth 2.0 process.
*/
public class InitializeOAuth extends Choreography {

	/**
	Create a new instance of the InitializeOAuth Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public InitializeOAuth(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/OAuth/InitializeOAuth"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return InitializeOAuthInputSet
	*/
	public InitializeOAuthInputSet newInputSet() {
		return new InitializeOAuthInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public InitializeOAuthResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new InitializeOAuthResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the InitializeOAuth
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class InitializeOAuthInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the AppKeyName input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_AppKeyName(String value) {
			this.setInput("AppKeyName", value);
		}


		/** 
		Set the value of the AppKeyValue input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_AppKeyValue(String value) {
			this.setInput("AppKeyValue", value);
		}


		/** 
		Set the value of the CustomCallbackID input for this Choreo. 

		@param String - (optional, string) A unique identifier that you can pass to eliminate the need to wait for a Temboo generated CallbackID. Callback identifiers may only contain numbers, letters, periods, and hyphens.
		*/
		public void set_CustomCallbackID(String value) {
			this.setInput("CustomCallbackID", value);
		}


		/** 
		Set the value of the ForwardingURL input for this Choreo. 

		@param String - (optional, string) The URL that Temboo will redirect your users to after they grant access to your application. This should include the "https://" or "http://" prefix and be a fully qualified URL.
		*/
		public void set_ForwardingURL(String value) {
			this.setInput("ForwardingURL", value);
		}


		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (conditional, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the Scope input for this Choreo. 

		@param String - (optional, string) Available permissions to request on behalf of the user are read, write and admin, multiple values separated by a comma (ex: "read,write"). Default (blank) is same as "read,write".
		*/
		public void set_Scope(String value) {
			this.setInput("Scope", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the InitializeOAuth Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class InitializeOAuthResultSet extends ResultSet {
		public InitializeOAuthResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AuthorizationURL" output from this Choreo execution

		@return String - (string) The authorization URL that the user needs to go to in order to grant access to your application.
		*/
		public String get_AuthorizationURL() {
			return this.getResultString("AuthorizationURL");
		}
		/** 
		Retrieve the value for the "CallbackID" output from this Choreo execution

		@return String - (string) An ID used to retrieve the callback data that Temboo stores once your application's user authorizes.
		*/
		public String get_CallbackID() {
			return this.getResultString("CallbackID");
		}
	}
	
}
