package com.temboo.Library.CloudMine.ObjectStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ObjectDelete

Deletes one or more specified keys.
*/
public class ObjectDelete extends Choreography {

	/**
	Create a new instance of the ObjectDelete Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ObjectDelete(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CloudMine/ObjectStorage/ObjectDelete"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ObjectDeleteInputSet
	*/
	public ObjectDeleteInputSet newInputSet() {
		return new ObjectDeleteInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ObjectDeleteResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ObjectDeleteResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ObjectDelete
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ObjectDeleteInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by CloudMine after registering your app.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the All input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that all keys should be deleted if the Keys input is left empty. Set to "true" to delete all keys.
		*/
		public void set_All(Boolean value) {
			this.setInput("All", value);
		}

		/** 
		Set the value of the All input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that all keys should be deleted if the Keys input is left empty. Set to "true" to delete all keys.
		*/
		public void set_All(String value) {
			this.setInput("All", value);	
		}
		/** 
		Set the value of the ApplicationIdentifier input for this Choreo. 

		@param String - (required, string) The application identifier provided by CloudMine after registering your app.
		*/
		public void set_ApplicationIdentifier(String value) {
			this.setInput("ApplicationIdentifier", value);
		}


		/** 
		Set the value of the Keys input for this Choreo. 

		@param String - (conditional, string) A comma separated list of keys to delete. Required unless specifying "true" for the All parameter.
		*/
		public void set_Keys(String value) {
			this.setInput("Keys", value);
		}


		/** 
		Set the value of the SessionToken input for this Choreo. 

		@param String - (conditional, string) The session token for an existing user (returned by the AccountLogin Choreo). This is only required if your app is performing this operation on behalf of another user.
		*/
		public void set_SessionToken(String value) {
			this.setInput("SessionToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ObjectDelete Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ObjectDeleteResultSet extends ResultSet {
		public ObjectDeleteResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from CloudMine.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
