package com.temboo.Library.Box.Folders;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateFolder

Updates the information about a folder.
*/
public class UpdateFolder extends Choreography {

	/**
	Create a new instance of the UpdateFolder Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateFolder(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Box/Folders/UpdateFolder"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateFolderInputSet
	*/
	public UpdateFolderInputSet newInputSet() {
		return new UpdateFolderInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateFolderResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateFolderResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateFolder
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateFolderInputSet extends InputSet {
		/** 
		Set the value of the FolderObject input for this Choreo. 

		@param String - (required, json) A JSON object representing the new folder information. See documentation for formatting examples.
		*/
		public void set_FolderObject(String value) {
			this.setInput("FolderObject", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved during the OAuth2 process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AsUser input for this Choreo. 

		@param String - (optional, string) The ID of the user. Only used for enterprise administrators to make API calls for their managed users.
		*/
		public void set_AsUser(String value) {
			this.setInput("AsUser", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma-separated list of fields to include in the response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the FolderID input for this Choreo. 

		@param String - (required, string) The id of the folder to update.
		*/
		public void set_FolderID(String value) {
			this.setInput("FolderID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateFolder Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateFolderResultSet extends ResultSet {
		public UpdateFolderResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Box.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
