package com.temboo.Library.Box.Discussions;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateDiscussion

Creates a new discussion for a particular folder.
*/
public class CreateDiscussion extends Choreography {

	/**
	Create a new instance of the CreateDiscussion Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateDiscussion(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Box/Discussions/CreateDiscussion"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateDiscussionInputSet
	*/
	public CreateDiscussionInputSet newInputSet() {
		return new CreateDiscussionInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateDiscussionResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateDiscussionResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateDiscussion
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateDiscussionInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved during the OAuth2 process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AsUser input for this Choreo. 

		@param String - (optional, string) The ID of the user. Only used for enterprise administrators to make API calls for their managed users.
		*/
		public void set_AsUser(String value) {
			this.setInput("AsUser", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) The description of the discussion.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma-separated list of fields to include in the response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the FolderID input for this Choreo. 

		@param String - (required, string) The id of the folder to create a discussion for.
		*/
		public void set_FolderID(String value) {
			this.setInput("FolderID", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The name of the discussion.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - (optional, vault file) The path to a vault file that you want to upload. Required unless using the FileContents input.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateDiscussion Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateDiscussionResultSet extends ResultSet {
		public CreateDiscussionResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Box.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
