package com.temboo.Library.Amazon.SNS;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddPermission

Creates a statement for a topic's access control policy which allows an AWS account to have access to the specified Amazon SNS actions.
*/
public class AddPermission extends Choreography {

	/**
	Create a new instance of the AddPermission Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddPermission(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/SNS/AddPermission"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddPermissionInputSet
	*/
	public AddPermissionInputSet newInputSet() {
		return new AddPermissionInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddPermissionResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddPermissionResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddPermission
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddPermissionInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSAccountId input for this Choreo. 

		@param Integer - (required, integer) The AWS account number of the user that will be granted access to a specified action. Enter account number omitting any dashes.
		*/
		public void set_AWSAccountId(Integer value) {
			this.setInput("AWSAccountId", value);
		}

		/** 
		Set the value of the AWSAccountId input for this Choreo as a String. 

		@param String - (required, integer) The AWS account number of the user that will be granted access to a specified action. Enter account number omitting any dashes.
		*/
		public void set_AWSAccountId(String value) {
			this.setInput("AWSAccountId", value);	
		}
		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the ActionName input for this Choreo. 

		@param String - (required, string) The action you want to allow for a specified user (i.e. DeleteTopic, Publish, GetTopicAttributes, etc).
		*/
		public void set_ActionName(String value) {
			this.setInput("ActionName", value);
		}


		/** 
		Set the value of the Label input for this Choreo. 

		@param String - (required, string) The unique identifier for the new policy statement.
		*/
		public void set_Label(String value) {
			this.setInput("Label", value);
		}


		/** 
		Set the value of the TopicArn input for this Choreo. 

		@param String - (required, string) The ARN of the topic whos access control policy you want to adjust.
		*/
		public void set_TopicArn(String value) {
			this.setInput("TopicArn", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the SNS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddPermission Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddPermissionResultSet extends ResultSet {
		public AddPermissionResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
